import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

public class WindowExample
{
    public static void main(String [] args)
    {
       AppFrame f = new AppFrame();

       f.setSize(200, 200);

       f.addWindowListener(new WindowAdapter() { public void
           windowClosing(WindowEvent e) {System.exit(0);}});

       f.show();
    }
}

class AppFrame extends Frame implements ActionListener
{
    Button b1, b2;
    LabelWindow window;

    AppFrame()
    {
        setLayout(new FlowLayout());
        b1 = new Button("Afficher la fentre");
        add(b1);
        b1.addActionListener(this);

        b2 = new Button("Cacher la fentre");
        add(b2);
        b2.addActionListener(this);

        window = new LabelWindow(this);
        window.setSize(300, 200);
        window.setLocation(300, 300);
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == b1){
            window.setVisible(true);
        }
        if(event.getSource() == b2){
            window.setVisible(false);
        }
    }
}


class LabelWindow extends Window
{
    Label label;

    LabelWindow(AppFrame af)
    {
        super(af);
        setLayout(new FlowLayout());
        label = new Label("Bien le bonjour de Java !");
        add(label);
    }

    public void paint (Graphics g)
    {
        int width = getSize().width;
        int height = getSize().height;

        g.drawRect(0, 0, --width, --height);
    }
}

