
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE=ListImages.class
    WIDTH=300
    HEIGHT=300 >
</APPLET>
*/

public class ListImages extends JApplet
{
    public void init()
    {
        Container contentPane = getContentPane();

        NewModel newmodel = new NewModel();
        NewRenderer newrenderer = new NewRenderer();

        JList jlist = new JList(newmodel);
        jlist.setCellRenderer(newrenderer);
        jlist.setVisibleRowCount(6);

        contentPane.add(new JScrollPane(jlist));
    }
}


class NewModel extends DefaultListModel
{
    public NewModel()
    {
        for(int loop_index = 0; loop_index <= 12; loop_index++) {
            addElement(new Object[] {"Item " + loop_index,
                new ImageIcon("item.jpg")});
        }
    }
}

class NewRenderer extends JLabel implements ListCellRenderer
{
    public NewRenderer()
    {
        setOpaque(true);
    }

    public Component getListCellRendererComponent(
        JList jlist, Object obj, int index, boolean isSelected,
        boolean focus)
    {
        NewModel model = (NewModel)jlist.getModel();

        setText((String)((Object[])obj)[0]);
        setIcon((Icon)((Object[])obj)[1]);

        if(!isSelected) {
            setBackground(jlist.getBackground());
            setForeground(jlist.getForeground());
        }
        else {
            setBackground(jlist.getSelectionBackground());
            setForeground(jlist.getSelectionForeground());
        }

        return this;
    }
}

