
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;

/*
<APPLET
    CODE=Slider5.class
    WIDTH=300
    HEIGHT=200 >
</APPLET>
*/


public class Slider5 extends JApplet implements ActionListener, 
                                               ChangeListener
{
    JSlider jslider = new JSlider(SwingConstants.HORIZONTAL, 0, 100, 0);
    JButton jbutton = new JButton("Largeur  60");

    public void init()
    {
        Container contentPane = getContentPane();
        contentPane.setLayout(new FlowLayout());

        jslider.addChangeListener(this);
        jslider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        jslider.setPaintTicks(true);
        jslider.setPaintLabels(true);
        jslider.setMajorTickSpacing(20);
        jslider.setMinorTickSpacing(10);

        contentPane.add(jslider);

        jbutton.addActionListener(this);
        contentPane.add(jbutton);
    }

    public void stateChanged(ChangeEvent e)
    {
        JSlider jslider1 = (JSlider) e.getSource();
        showStatus("minimale : " + jslider1.getMinimum() +
            ", maximale : " + jslider1.getMaximum() +
            ", actuelle : " + jslider1.getValue() +
            ", largeur: " + jslider1.getExtent());
    }

    public void actionPerformed(ActionEvent e)
    {
        jslider.setExtent(60);
        jslider.revalidate();
    }
}


