
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE=Viewport.class
    WIDTH=700
    HEIGHT=200 >
</APPLET>
*/


public class Viewport extends JApplet
{
    public Viewport()
    {
        Container contentPane = getContentPane();

        JViewport jviewport = new JViewport();
        JPanel jpanel = new JPanel();

        jpanel.add(new JLabel(new ImageIcon("viewport.jpg")));

        jviewport.setView(jpanel);

        contentPane.add(jviewport, BorderLayout.CENTER);
        contentPane.add(new ButtonPanel(jviewport), BorderLayout.SOUTH);
    }
}


class ButtonPanel extends JPanel implements ActionListener
{
    JViewport jviewport;

    JButton button1 = new JButton("Vers la gauche");
    JButton button2 = new JButton("Vers le haut");
    JButton button3 = new JButton("Vers le bas");
    JButton button4 = new JButton("Vers la droite");

    public ButtonPanel(JViewport vport)
    {
        jviewport = vport;

        add(button1);
        add(button2);
        add(button3);
        add(button4);

        button1.addActionListener(this);
        button2.addActionListener(this);
        button3.addActionListener(this);
        button4.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e)
    {
        Point position = jviewport.getViewPosition();

        if(e.getSource() == button1) position.x += 10;
        else if(e.getSource() == button2) position.y += 10;
        else if(e.getSource() == button3) position.y -= 10;
        else if(e.getSource() == button4) position.x -= 10;

        jviewport.setViewPosition(position);
    }
}



