import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE = ComboBoxImages.class
    WIDTH = 400
    HEIGHT = 200 >
</APPLET>
*/

public class ComboBoxImages extends JApplet
{
    public void init()
    {
        Container contentPane = getContentPane();
        contentPane.setLayout(new FlowLayout());

        NewModel newmodel = new NewModel();
        NewRenderer newrenderer = new NewRenderer();

        JComboBox jcombobox = new JComboBox(newmodel);
        jcombobox.setRenderer(newrenderer);

        contentPane.add(new JScrollPane(jcombobox));
    }
}

class NewModel extends DefaultComboBoxModel
{
    public NewModel()
    {
        for(int loop_index = 0; loop_index <= 12; loop_index++) {
            addElement(new Object[] {"Item " + loop_index,
                new ImageIcon("combo.jpg")});
        }
    }
}

class NewRenderer extends JLabel implements ListCellRenderer
{
    public NewRenderer()
    {
        setOpaque(true);
    }

    public Component getListCellRendererComponent(
        JList jlist, Object obj, int index, boolean isSelected,
        boolean focus)
    {
        NewModel model = (NewModel)jlist.getModel();

        setText((String)((Object[])obj)[0]);
        setIcon((Icon)((Object[])obj)[1]);

        if(!isSelected) {
            setBackground(jlist.getBackground());
            setForeground(jlist.getForeground());
        }
        else {
            setBackground(jlist.getSelectionBackground());
            setForeground(jlist.getSelectionForeground());
        }

        return this;
    }
}