import java.awt.*;
import java.io.File;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.filechooser.*;

public class FileChooserExample extends JFrame implements ActionListener
{
    JFileChooser chooser = new JFileChooser();
    JButton jbutton = new JButton("Cliquez pour ouvrir une bote de choix");
    JTextField jtextfield = new JTextField(30);

    public FileChooserExample()
    {
        super();
        Container contentPane = getContentPane();

        contentPane.setLayout(new FlowLayout());
        contentPane.add(jbutton);
        contentPane.add(jtextfield);

        jbutton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e)
    {
        int result = chooser.showOpenDialog(null);
        File fileobj = chooser.getSelectedFile();

        if(result == JFileChooser.APPROVE_OPTION) {
            jtextfield.setText("Vous avez choisi " + fileobj.getPath());
        } else if(result == JFileChooser.CANCEL_OPTION) {
            jtextfield.setText("Vous avez annul l'opration.");
        }
    }

    public static void main(String args[])
    {
        JFrame f = new FileChooserExample();
        f.setBounds(200, 200, 400, 200);

        f.setVisible(true);

        f.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e)
            {
                System.exit(0);
            }
        });
    }
}
