import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE = TabbedPaneOrientation.class
    WIDTH = 500
    HEIGHT = 200 >
</APPLET>
*/

public class TabbedPaneOrientation extends JApplet implements 
    ActionListener
{
    JTabbedPane jtabbedpane = new JTabbedPane(SwingConstants.BOTTOM);
    JButton button1, button2, button3, button4;

    public void init()
    {
        Container contentPane = getContentPane();

        JPanel buttonPanel = new JPanel();

        JPanel jpanel1 = new JPanel();
        JPanel jpanel2 = new JPanel();
        JPanel jpanel3 = new JPanel();

        jtabbedpane.setTabPlacement(JTabbedPane.TOP);

        jtabbedpane.addTab("Volet 1",
                    new ImageIcon("tab.jpg"),
                    jpanel1, "Volet numro 1");

        jtabbedpane.addTab("Volet 2",
                    new ImageIcon("tab.jpg"),
                    jpanel2, "Volet numro 2");

        jtabbedpane.addTab("Volet 3",
                    new ImageIcon("tab.jpg"),
                    jpanel3, "Volet numro 3");

        button1 = new JButton("En haut");
        button2 = new JButton("A gauche");
        button3 = new JButton("A droite");
        button4 = new JButton("En bas");

        buttonPanel.add(button1);
        buttonPanel.add(button2);
        buttonPanel.add(button3);
        buttonPanel.add(button4);

        button1.addActionListener(this);
        button2.addActionListener(this);
        button3.addActionListener(this);
        button4.addActionListener(this);

        contentPane.setLayout(new BorderLayout());

        contentPane.add(jtabbedpane, BorderLayout.CENTER);
        contentPane.add(buttonPanel, BorderLayout.SOUTH);
    }

    public void actionPerformed(ActionEvent e)
    {
        if(e.getSource() == button1) {
            jtabbedpane.setTabPlacement(JTabbedPane.TOP);
        }
        else if(e.getSource() == button2) {
            jtabbedpane.setTabPlacement(JTabbedPane.LEFT);
        }
        else if(e.getSource() == button3) {
            jtabbedpane.setTabPlacement(JTabbedPane.RIGHT);
        }
        else if(e.getSource() == button4) {
            jtabbedpane.setTabPlacement(JTabbedPane.BOTTOM);
        }
            jtabbedpane.validate();
    }
}
