import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.table.*;

/*
<APPLET
    CODE = TableAdd.class
    WIDTH = 350
    HEIGHT = 280 >
</APPLET>
*/

public class TableAdd extends JApplet
{
    Object[] data = new Object[5];

    DefaultTableModel defaulttablemodel = new DefaultTableModel();
    JTable jtable = new JTable(defaulttablemodel);

    public void init() 
    {
        for(int column = 0; column < 5; column++){
            defaulttablemodel.addColumn("Colonne " + column);
        }

        for(int row = 0; row < 5; row++) {
            for(int column = 0; column < 5; column++) {
                data[column] = "Cellule " + row + "," + column;
            }
            defaulttablemodel.addRow(data);
        }
        //jtable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        getContentPane().add(new JScrollPane(jtable), BorderLayout.CENTER);
        getContentPane().add(new jpanel(), BorderLayout.SOUTH);
    }

    class jpanel extends JPanel implements ActionListener
    {
        private JButton jbutton1 = new JButton("Crer une ligne"),
                        jbutton2 = new JButton("Crer une colonne");

        public jpanel() 
        {
            add(jbutton1);
            add(jbutton2);

            jbutton1.addActionListener(this); 
            jbutton2.addActionListener(this); 

        }
        
        public void actionPerformed(ActionEvent e) 
        {
            if(e.getSource() == jbutton1) {
                int numberrows = defaulttablemodel.getRowCount();
                int numbercolumns = defaulttablemodel.getColumnCount();

                Object[] data = new Object[numbercolumns];

                for(int column = 0; column < numbercolumns; column++) {
                    data[column] = "Cellule " + numberrows + "," + column;
                }
                defaulttablemodel.addRow(data);

            } else if(e.getSource() == jbutton2) {
                int numberrows = defaulttablemodel.getRowCount();
                int numbercolumns = defaulttablemodel.getColumnCount();
                defaulttablemodel.addColumn("Colonne " + numbercolumns);

                for(int row = 0; row < numberrows; row++) {
                    defaulttablemodel.setValueAt("Cellule " + row + "," + numbercolumns, row, numbercolumns);
                }
                
                jtable.sizeColumnsToFit(0);
            }
        }
    }
}

