import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.io.IOException;

public class EditorPaneURL extends JFrame 
{
    JEditorPane jeditorpane = new JEditorPane();

    public EditorPaneURL() 
    {
        super("Application JEditorPane");

        Container contentPane = getContentPane();

        jeditorpane.setEditable(false);

        String urlstring = "file:" + System.getProperty("user.dir") +
             System.getProperty("file.separator") +
             "page2.html";

        try {
            jeditorpane.setPage(urlstring);
        }
        catch(IOException e) {}

        jeditorpane.addHyperlinkListener(new HyperlinkListener(){
            public void hyperlinkUpdate(HyperlinkEvent e) 
            {
                try {
                    jeditorpane.setPage(e.getURL());
                }
                catch(IOException e2) {}
            }

        });

        contentPane.add(jeditorpane);
    }

    public static void main(String args[]) 
    {
        final JFrame jframe = new EditorPaneURL();

        jframe.setBounds(100, 100, 300, 350);
        jframe.setVisible(true);
        jframe.setBackground(Color.white);
        jframe.setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        jframe.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}


