import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

public class DialogExample
{
    public static void main(String [] args)
    {
       Dialogframe f = new Dialogframe("Bote de dialogue");

       f.setSize(400, 200);

       f.addWindowListener(new WindowAdapter() { public void
           windowClosing(WindowEvent e) {System.exit(0);}});

       f.show();
    }
}

class Dialogframe extends Frame implements ActionListener
{
    Menu menu1;
    MenuBar menubar1;
    MenuItem menuitem1;
    Label label;
    OkCancelDialog dialog;

    Dialogframe(String title)
    {
        super(title);
        label = new Label("Bien le bonjour de Java !");
        setLayout(new GridLayout(1, 1));
        add(label);
        menubar1 = new MenuBar();

        menu1 = new Menu("Fichier");

        menuitem1 = new MenuItem("Bote de dialogue...");
        menu1.add(menuitem1);
        menuitem1.addActionListener(this);

        menubar1.add(menu1);

        setMenuBar(menubar1);
        dialog = new OkCancelDialog(this, "Bote de dialogue", true);
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == menuitem1){
            dialog.setVisible(true);
            label.setText(dialog.data);
        }
    }
}

class OkCancelDialog extends Dialog implements ActionListener
{
    Button ok, cancel;
    TextField text;
    public String data;

    OkCancelDialog(Frame hostFrame, String title, boolean dModal)
    {
        super(hostFrame, title, dModal);
        setSize(300, 100);
        setLayout(new FlowLayout());
        ok = new Button("OK");
        add(ok);
        ok.addActionListener((ActionListener)this);
        cancel = new Button("Annuler");
        add(cancel);
        cancel.addActionListener(this);
        text = new TextField(30);
        add(text);
        data = new String("");
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == ok){
            data = text.getText();
        } else {
            data = "";
        }
        setVisible(false);
    }
}
