
import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

/*
<APPLET
    CODE=PopupExample.class
    WIDTH=200
    HEIGHT=200 >
</APPLET>
*/

public class PopupExample extends Applet implements ActionListener, 
    MouseListener {

    Label label;
    PopupMenu popup;
    MenuItem menuitem1, menuitem2, menuitem3, menuitem4;

    public void init()
    {
        popup = new PopupMenu("Menu");
        menuitem1 = new MenuItem("Option 1");
        menuitem1.addActionListener(this);
        menuitem2 = new MenuItem("Option 2");
        menuitem2.addActionListener(this);
        menuitem3 = new MenuItem("Option 3");
        menuitem3.addActionListener(this);
        menuitem4 = new MenuItem("Option 4");
        menuitem4.addActionListener(this);
        popup.add(menuitem1);
        popup.addSeparator();
        popup.add(menuitem2);
        popup.addSeparator();
        popup.add(menuitem3);
        popup.addSeparator();
        popup.add(menuitem4);
        add(popup);
        label = new Label("Bien le bonjour de Java !");
        add(label);
        addMouseListener(this);
    }

    public void mousePressed(MouseEvent e)
    {
        if(e.getModifiers() != 0){
            popup.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e){}
    public void mouseReleased(MouseEvent e){}
    public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == menuitem1)
            label.setText("Vous avez choisi l'option 1");
        else if(event.getSource() == menuitem2)
            label.setText("Vous avez choisi l'option 2");
        else if(event.getSource() == menuitem3)
            label.setText("Vous avez choisi l'option 3");
        else if(event.getSource() == menuitem4)
            label.setText("Vous avez choisi l'option 4");
    }
}