
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE=ScrollBarExample.class
    WIDTH=300
    HEIGHT=200 >
</APPLET>
*/

public class ScrollBarExample extends JApplet
{
    private JScrollBar vsb = new JScrollBar(JScrollBar.VERTICAL, 0,
                                            0, 0, 180);
    private JpanelExample j = new JpanelExample();

    public void init()
    {
        Container contentPane = getContentPane();

        contentPane.add(j, BorderLayout.CENTER);
        contentPane.add(vsb, BorderLayout.EAST);

        vsb.addAdjustmentListener(new AdjustmentListener()
        {
            public void adjustmentValueChanged(
                                             AdjustmentEvent e) {
                JScrollBar sb = (JScrollBar)e.getSource();
                j.setScrolledPosition(e.getValue());
                j.repaint();
            }
        });
    }
}

class JpanelExample extends JPanel
{
    JLabel jlabel = new JLabel("Bien le bonjour de Java !");
    int y = 0;

    JpanelExample()
    {
        add(jlabel);
    }

    public void paintComponent(Graphics g)
    {
        super.paintComponent(g);

        jlabel.setLocation(0, y);
    }

    public void setScrolledPosition(int newposition)
    {
        y = newposition;
    }
}

