import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE = SeparatorEvents.class
    WIDTH = 400
    HEIGHT = 200 >
</APPLET>
*/

public class SeparatorEvents extends JApplet implements ComponentListener
{
    JSeparator jseparator = new JSeparator(JSeparator.VERTICAL);
    Dimension dimension = jseparator.getPreferredSize();

    public void init()
    {
        Container contentPane = getContentPane();

        contentPane.setLayout(new FlowLayout());

        contentPane.add(new JTextField("Bien le bonjour de Swing !"));
        contentPane.add(jseparator);
        contentPane.add(new JTextField("Bien le bonjour de Swing !"));

        addComponentListener(this);
    }

    public void componentShown(ComponentEvent e)
    {
        jseparator.setPreferredSize(new Dimension(dimension.width,
            getSize().height));
        jseparator.revalidate();
    }

    public void componentResized(ComponentEvent e)
    {
        jseparator.setPreferredSize(new Dimension(dimension.width,
            getSize().height));
        jseparator.revalidate();
    }

    public void componentMoved(ComponentEvent e) {}
    public void componentHidden(ComponentEvent e) {}
}
