import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/*
<APPLET
    CODE = SwingMenuAccelerator.class
    WIDTH = 350
    HEIGHT = 280 >
</APPLET>
*/

public class SwingMenuAccelerator extends JApplet implements ActionListener
{
    public void init()
    {
        Container contentPane = getContentPane();

        JMenuBar jmenubar = new JMenuBar();
        JMenu jmenu = new JMenu("Fichier");

        JMenuItem jmenuitem1 = new JMenuItem("Nouveau..."),
            jmenuitem2 = new JMenuItem("Ouvrir..."),
            jmenuitem3 = new JMenuItem("Quitter");

        jmenuitem1.setMnemonic(KeyEvent.VK_N);

        KeyStroke keystroke = KeyStroke.getKeyStroke(KeyEvent.VK_N,
            Event.CTRL_MASK);
        jmenuitem1.setAccelerator(keystroke);

        jmenu.add(jmenuitem1);
        jmenu.add(jmenuitem2);
        jmenu.addSeparator();
        jmenu.add(jmenuitem3);

        jmenuitem1.setActionCommand("Vous avez choisi Nouveau");
        jmenuitem2.setActionCommand("Vous avez choisi Ouvrir");

        jmenuitem1.addActionListener(this);
        jmenuitem2.addActionListener(this);

        jmenubar.add(jmenu);
        setJMenuBar(jmenubar);
    }

    public void actionPerformed(ActionEvent e)
    {
        JMenuItem jmenuitem = (JMenuItem)e.getSource();

        showStatus(jmenuitem.getActionCommand());
    }
}
