import java.awt.*;
import javax.swing.*;
import javax.swing.text.*;

/*
<APPLET
    CODE = TextPaneAttributes.class
    WIDTH = 350
    HEIGHT = 280>
</APPLET>
*/

public class TextPaneAttributes extends JApplet
{
    JTextPane jtextpane = new JTextPane();
    String string = new String("Swing vous salue bien !\r\n");
    int stringlength = string.length();
    int position = 0;

    public void init()
    {
        Container contentPane = getContentPane();

        jtextpane.setText(string);
        StyledDocument styleddocument = jtextpane.getStyledDocument();

        Style normal = styleddocument.addStyle("normal", null);
        StyleConstants.setFontFamily(normal, "SansSerif");

        Style red = styleddocument.addStyle("rouge", normal);
        StyleConstants.setForeground(red, Color.red);

        Style bold = styleddocument.addStyle("gras", normal);
        StyleConstants.setBold(bold, true);

        Style italic = styleddocument.addStyle("italique", normal);
        StyleConstants.setItalic(italic, true);

        Style big = styleddocument.addStyle("grand", normal);
        StyleConstants.setFontSize(big, 24);

        styleddocument.setLogicalStyle(position, normal);

        position += stringlength;
        jtextpane.setCaretPosition(styleddocument.getLength());
        jtextpane.replaceSelection(string);
        styleddocument = jtextpane.getStyledDocument();
        styleddocument.setLogicalStyle(position, red);

        position += stringlength;
        jtextpane.setCaretPosition(styleddocument.getLength());
        jtextpane.replaceSelection(string);
        styleddocument = jtextpane.getStyledDocument();
        styleddocument.setLogicalStyle(position, bold);

        position += stringlength;
        jtextpane.setCaretPosition(styleddocument.getLength());
        jtextpane.replaceSelection(string);
        styleddocument = jtextpane.getStyledDocument();
        styleddocument.setLogicalStyle(position, italic);

        position += stringlength;
        jtextpane.setCaretPosition(styleddocument.getLength());
        jtextpane.replaceSelection(string);
        styleddocument = jtextpane.getStyledDocument();
        styleddocument.setLogicalStyle(position, big);

        contentPane.add(jtextpane);
    }
}
