CREATE PROCEDURE RunFinancials 
@OverNight datetime,
@MidDay datetime,
@CloseOfBusiness datetime
AS

DECLARE @OverNightSales money
DECLARE @MidDaySales money
DECLARE @DayCurrentSales money
DECLARE @DayPreviousSales money

WHILE (DATEPART(mi, GETDATE()) 
    BETWEEN DATEPART(mi, DATEADD(mi, -10, @OverNight)) 
    AND DATEPART(mi, @OverNight)
    AND DATEPART(mm, @OverNight) = DATEPART(mm, GETDATE())
    AND DATEPART(dd, @OverNight) = DATEPART(dd, GETDATE()))
BEGIN


IF DATEPART(hh, GETDATE()) < DATEPART(hh, @OverNight)
    AND DATEPART(dd, GETDATE()) = DATEPART(dd, @OverNight)
    BEGIN
        SET @OverNightSales = (SELECT SUM(Qty) FROM Sales 
            WHERE ord_date BETWEEN GETDATE() 
            AND DATEADD(d, -1, GETDATE()))
    END
IF DATEPART(hh, GETDATE()) < DATEPART(hh, @MidDay)
    AND DATEPART(dd, GETDATE()) = DATEPART(dd, @MidDay)
    BEGIN
        SET @MidDaySales = (SELECT SUM(Qty) FROM Sales 
            WHERE ord_date BETWEEN DATEPART(hh, 
            @OverNight) AND DATEPART(hh, GETDATE()) 
            AND DATEPART(mm, ord_date) = DATEPART(mm, GETDATE())
            AND DATEPART(dd, ord_date) = DATEPART(dd, GETDATE())
            AND DATEPART(yyyy, ord_date) = DATEPART(yyyy, GETDATE()))
        RETURN @MidDaySales
    END
IF DATEPART(hh, GETDATE()) < DATEPART(hh, @CloseOfBusiness)
    AND DATEPART(dd, GETDATE()) = DATEPART(dd, @CloseOfBusiness)
    BEGIN
        SET @DayCurrentSales = (SELECT SUM(Qty) FROM Sales WHERE ord_date 
            BETWEEN DATEPART(hh, @OverNight) AND DATEPART(hh, GETDATE())
            AND DATEPART(mm, ord_date) = DATEPART(mm, GETDATE())
            AND DATEPART(dd, ord_date) = DATEPART(dd, GETDATE())
            AND DATEPART(yyyy, ord_date) = DATEPART(yyyy, GETDATE()))
        SET @DayPreviousSales = (SELECT SUM(Qty) FROM Sales WHERE ord_date 
            BETWEEN DATEPART(hh, @OverNight) AND DATEPART(hh, GETDATE())
            AND DATEPART(mm, ord_date) = DATEPART(mm, DATEADD(d, -1,    
            GETDATE()))AND DATEPART(dd, ord_date) = DATEPART(dd, DATEADD(d, 
            -1, GETDATE())) AND DATEPART(yyyy, ord_date) = DATEPART(yyyy, 
            DATEADD(d, -1, GETDATE())))
        RETURN @DayCurrentSales - @DayPreviousSales
    END
    BREAK
END
