# This file is autogenerated. Instead of editing this file, please use the
# migrations feature of ActiveRecord to incrementally modify your database, and
# then regenerate this schema definition.

ActiveRecord::Schema.define(:version => 7) do

  create_table "line_items", :force => true do |t|
    t.column "product_id",  :integer,                               :null => false
    t.column "order_id",    :integer,                               :null => false
    t.column "quantity",    :integer,                               :null => false
    t.column "total_price", :decimal, :precision => 8, :scale => 2, :null => false
  end

  add_index "line_items", ["product_id"], :name => "fk_line_item_products"
  add_index "line_items", ["order_id"], :name => "fk_line_item_orders"

  create_table "orders", :force => true do |t|
    t.column "name",     :string
    t.column "address",  :text
    t.column "email",    :string
    t.column "pay_type", :string, :limit => 10
  end

  create_table "products", :force => true do |t|
    t.column "title",       :string
    t.column "description", :text
    t.column "image_url",   :string
    t.column "price",       :decimal, :precision => 8, :scale => 2, :default => 0.0
  end

  create_table "sessions", :force => true do |t|
    t.column "session_id", :string
    t.column "data",       :text
    t.column "updated_at", :datetime
  end

  add_index "sessions", ["session_id"], :name => "index_sessions_on_session_id"

  create_table "users", :force => true do |t|
    t.column "name",            :string
    t.column "hashed_password", :string
    t.column "salt",            :string
  end

end
