// ------------------------------------------------------
// classe utilisee pour la saisie 
// C. Dabancourt
// date : 15/07/2001
// ------------------------------------------------------

package iut.algo;
import java.io.*;

final public class Clavier extends Object{

//-----------------------------------------------------------------------
	// -- saisir une chaine de caractres String : necessaire pour toutes les autres lectures ...
        public static String lireString() {
		int erreur = -1;
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		String s = new String("");

		while (erreur == -1){
			try{
				s = in.readLine();
				erreur = 0;
			} catch (IOException e) {
				System.out.println("erreur : saisissez une chaine");
			}
		}
		return s;
	}

//-----------------------------------------------------------------------
	// -- saisir d'un entier Integer
        public static Integer lireInteger() {
		Integer resultat = new Integer(0);
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = new Integer(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre Integer entre "+Integer.MIN_VALUE+" et "+Integer.MAX_VALUE);
			}
		}
		return resultat;
	}

//-----------------------------------------------------------------------
	// -- saisir d'un caractre char
        public static char lire_char() {

		char resultat = 0;
		int erreur = -1;

		while (erreur == -1){
			try {	
				resultat = lireString().charAt(0);
				erreur=0;
			} catch (StringIndexOutOfBoundsException e){ 
				System.out.println("erreur : saisissez un caractre !"); 
				resultat=(char)0;
				erreur=-1;
			}
			/*if ( (int)resultat > 20 && (int)resultat < 200){
				erreur = 0;
			} else {
				System.out.println("erreur : saisissez un caractre !");
			}*/
		}
		return resultat;
	}


//-----------------------------------------------------------------------
	// -- saisir d'un entier int
        public static int lire_int() {
		int resultat = 0;
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = Integer.parseInt(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier (int) entre "+Integer.MIN_VALUE+" et "+Integer.MAX_VALUE);
			}
		}
		return resultat;
	}

//-----------------------------------------------------------------------
        public static Double lireDouble()
	{
		Double resultat = new Double(0);
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = new Double(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre Double entre "+Double.MIN_VALUE+" et "+Double.MAX_VALUE);
			}
                }
                return resultat;
	}

//-----------------------------------------------------------------------
        public static double lire_double()
	{
		double resultat = 0.0;
		int erreur = -1;

		while (erreur == -1){
			try{
				Double r = Double.valueOf(lireString());
				resultat = r.doubleValue();
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre rel (double) entre "+Double.MIN_VALUE+" et "+Double.MAX_VALUE);
			}
                }
                return resultat;
	}

//-----------------------------------------------------------------------
        public static Float lireFloat()
	{
		Float resultat = new Float(0);
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = new Float(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre Floatentre "+Float.MIN_VALUE+" et "+Float.MAX_VALUE);
			}
                }
                return resultat;
	}

//-----------------------------------------------------------------------
        public static float lire_float()
	{
		float resultat = 0;
		int erreur = -1;

		while (erreur == -1){
			try{
				Float r = Float.valueOf(lireString());
				resultat = r.floatValue();
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre rel (float) entre "+Float.MIN_VALUE+" et "+Float.MAX_VALUE);

			}
                }
                return resultat;
	}
//-----------------------------------------------------------------------
        public static Short lireShort()
	{
		Short resultat = new Short("0");
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = new Short(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier (Short) entre "+Short.MIN_VALUE+" et "+Short.MAX_VALUE);
			}
                }
                return resultat;
	}

//-----------------------------------------------------------------------
        public static short lire_short()
	{
		short resultat = 0;
		int erreur = -1;

		while (erreur == -1){
			try{
				Short r = Short.valueOf(lireString());
				resultat = r.shortValue();
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier (short) entre "+Short.MIN_VALUE+" et "+Short.MAX_VALUE);

			}
                }
                return resultat;
	}
//-----------------------------------------------------------------------
        public static Long lireLong()
	{
		Long resultat = new Long(0);
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = new Long(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier entre "+Long.MIN_VALUE+" et "+Long.MAX_VALUE);
			}
                }
                return resultat;
	}

//-----------------------------------------------------------------------
        public static long lire_long()
	{
		long resultat = 0;
		int erreur = -1;

		while (erreur == -1){
			try{
				Long r = Long.valueOf(lireString());
				resultat = r.longValue();
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier (long) entre "+Long.MIN_VALUE+" et "+Long.MAX_VALUE);

			}
                }
                return resultat;
	}
//-----------------------------------------------------------------------
        public static Byte lireByte()
	{
		Byte resultat = new Byte("0");
		int erreur = -1;

		while (erreur == -1){
			try{
				resultat = new Byte(lireString());
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier entre "+Byte.MIN_VALUE+" et "+Byte.MAX_VALUE);
			}
                }
                return resultat;
	}

//-----------------------------------------------------------------------
        public static byte lire_byte() {
		byte resultat = 0;
		int erreur = -1;

		while (erreur == -1){
			try{
				Byte r = Byte.valueOf(lireString());
				resultat = r.byteValue();
				erreur = 0;
			} catch (NumberFormatException e) {
				System.out.println("erreur : saisissez un nombre entier (byte) entre "+Byte.MIN_VALUE+" et "+Byte.MAX_VALUE);

			}
		}
		return resultat;
	}

//-----------------------------------------------------------------------
        public static boolean lire_boolean() {
		boolean resultat = true;
		int erreur = -1;
		char c='x';

		while (erreur == -1){
			c = lire_char();
			if ( (c=='V')||(c=='v')||(c=='1') ){
				erreur = 0;
				resultat = true;
			} else if ( (c=='F')||(c=='f')||(c=='0') ){
				erreur = 0;
				resultat = false;
			} else {
				System.out.println("erreur : saisissez un nombre boolean (0, 1),(V,F)");
			}
		}
		return resultat;
	}



        public static Boolean lireBoolean() {
		Boolean resultat = new Boolean(lire_boolean());
		return resultat;
	}	


} 

