/**
 * Classe ListeReel
 * Une ListeReel est constue de CelluleReel.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */

public class ListeReel
{


	private CelluleReel tete;
	
	public ListeReel ( ) 
	{
		tete = null ;
	}


	public boolean estVide ( ) 
	{
		return(tete == null);
	}



	public void ajouterTete (float e )
	{
		CelluleReel nouvCel;
	
		nouvCel = new CelluleReel(e, tete) ;   // la nouvelle cellule pointe comme tte, et contient llment e.
		tete = nouvCel ;
	}


	public void ajouterQueue (float e) 
	{
		CelluleReel ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleReel (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleReel ptr;
		
		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	
	public boolean contient(float x) 
	{
		CelluleReel iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() == x) 
				return true;		// on quitte la mthode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}
	
	
	public void afficher ( ) 
	{
		CelluleReel ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		System.out.println("***");
	}
}

