package iut.algo;

import java.util.*;
import iut.algo.ArbreBinaireEntier;


public class ABREntier extends ArbreBinaireEntier{


	public ABREntier(){	// un arbre vide
		super();
	}


	public ABREntier(int valeur){	// un arbre avec une valeur
		super(valeur);
	}

	public boolean ajouterValeur (int val){ 
		ArbreBinaireEntier g,d;
		if (racine==null){ 
			racine = new Noeud(val);
			return (true) ; 
		} 
		else {
			if (val==racine.getValeur()) 
				return false ; 
			else if (val<racine.getValeur()){ 
				g = racine.getGauche() ;
				if (g != null)
					return ((ABREntier)g).ajouterValeur(val); // polymorphisme
				else{
					racine.setGauche(new ABREntier(val));
					return true;
				}
			} 
			else { 
				d = racine.getDroit() ; 
				if (d != null)
					return ((ABREntier)d).ajouterValeur(val); // polymorphisme
				else{
					racine.setDroit(new ABREntier(val));
					return true;
				}
			}
		} 
	} 
	
	
	public boolean rechercher (int val){ 
		ArbreBinaireEntier g,d;
		if (racine==null)
			return false;
		else if (val==racine.getValeur()) 
			return true; 
		else {
			if (val<racine.getValeur()){ 
				g = racine.getGauche() ;
				if (g != null)
					return (((ABREntier)g).rechercher(val));
				else
					return false;
			} 
			else { 
				d = racine.getDroit() ; 
				if (d != null)
					return (((ABREntier)d).rechercher(val)); 
				else
					return false;
			}
		}
	}
	

	
}