package iut.algo;

import java.util.*;


public class ArbreBinaireEntier{

	protected int valeur;
	protected ArbreBinaireEntier gauche, droit;

	public ArbreBinaireEntier(){	// un arbre vide
		gauche=null;
		droit=null;
		this.valeur = 0;
	}


	public ArbreBinaireEntier(int valeur){	// un arbre avec une valeur
		gauche=null;
		droit=null;
		this.valeur = valeur;
	}


	public ArbreBinaireEntier(int valeur, ArbreBinaireEntier gauche, ArbreBinaireEntier droit){ 
		this.gauche=gauche;
		this.droit=droit;
		this.valeur = valeur;
	}
	
	public ArbreBinaireEntier getDroit(){	return droit;}
	public ArbreBinaireEntier getGauche(){	return gauche;}
	public void setDroit(ArbreBinaireEntier droit){  this.droit  = droit;}
	public void setGauche(ArbreBinaireEntier gauche){this.gauche = gauche;}
	
	public int getValeur(){		return valeur;}
	public boolean estFeuille(){	return (droit==null && gauche==null);}
	
 
/*	public String toString(){ 
		String s="";
		
		if (racine !=null) { 
			s = "[" + (racine.getGauche()).toString()+"]"; 
			s = s + " "+ racine.getValeur()+ " "; 
			s = s + "["+ (racine.getDroit()).toString()+"]"; 
			return s ; 
		} 
		else 
			return (""); 
	} 
*/
	/*******************************
	 * les parcours                *
	 *******************************/
	 	
	public void parcoursPrefixe() {
		System.out.println("parcours Prefixe");
		parcoursPrefixe(this);
	}
	
	public void parcoursPrefixe(ArbreBinaireEntier ab) 
	{
		System.out.println(ab.valeur);					// traitement
		if (ab.getGauche() != null) parcoursPrefixe(ab.getGauche());	// appel rcursif
		if (ab.getDroit()  != null) parcoursPrefixe(ab.getDroit());		// appel rcursif
	}
	
	/*******************************/
	public void parcoursInfixe() {
		System.out.println("parcours Infixe");
		parcoursInfixe(this);
	}
	
	public void parcoursInfixe(ArbreBinaireEntier ab) 
	{
		if (ab.getGauche() != null) parcoursInfixe(ab.getGauche());	// appel rcursif
		System.out.print("*");
		System.out.println(ab.getValeur());				// traitement
		if (ab.getDroit()  != null) parcoursInfixe(ab.getDroit());	// appel rcursif
	}
	
	/*******************************/
	public void parcoursSuffixe() {
		System.out.println("parcours Suffixe");
		parcoursSuffixe(this);
	}
	
	public void parcoursSuffixe(ArbreBinaireEntier ab) 
	{
		if (ab.getGauche() != null) parcoursSuffixe(ab.getGauche());// appel rcursif
		if (ab.getDroit()  != null) parcoursSuffixe(ab.getDroit());	// appel rcursif
		System.out.println(ab.getValeur());				// traitement
	}
	
	/*******************************/
/*	public void parcoursLargeur() // pas recursif !
	{
		ArbreBinaireEntier ab;
		
		System.out.println("parcours Largeur");
		
		ListeNoeud liste = new ListeNoeud();
		liste.ajouterTete(this);
		
		while (liste.estVide() == false){
			ab = liste.retirerQueue(0);
			System.out.println(n.getValeur());
			if (ab.getGauche() != null) liste.ajouterTete(ab.getGauche());
			if (ab.getDroit()  != null) liste.ajouterTete(ab.getDroit();
		}		
	}
*/
	
}