/** Classe Puissance4
* ============
*@ author Dabancourt
*@ version du 26/04/03
*/

class  CelluleChoix{

	int miniMax, indiceMiniMax;	//minMax doit etre initialise  0 par defaut
	CelluleChoix possibilite [];
	//boolean chercheMax;

	public CelluleChoix(int miniMax, int indiceMiniMax){
		this.miniMax=miniMax;
		this.indiceMiniMax=indiceMiniMax;
		possibilite = new CelluleChoix[Damier.dimensionH];
	}

	public void setMiniMax(int miniMax){
		this.miniMax=miniMax;
	}
	public int getMiniMax(){
		return miniMax;
	}
	public void setMiniMax(boolean calculMaxi){
	// des fois le MAX, des fois le mini
		int valeur=-1;		// entre {6,5} on a -5>-6 => -5  => 5=mini
		if (calculMaxi)
			valeur=1;	// entre {6,5} on a 6>5   => 6=max
	
		int debut=0;
		while (possibilite[debut]==null)
			debut++;
		miniMax = possibilite[debut].miniMax;
		indiceMiniMax = debut;
		if (Puissance4.debug) System.out.println(" DEBUT="+miniMax);
				
		for (int i=debut+1; i<Damier.dimensionH; i++){
			if (possibilite[i]!=null){
				if (Puissance4.debug)  System.out.print(" indice=>>>"+possibilite[i].miniMax);

				if (valeur*possibilite[i].miniMax>valeur*miniMax){
					if (Puissance4.debug)  System.out.print(" "+possibilite[i].miniMax+"<"+miniMax+"\t");
					miniMax = possibilite[i].miniMax;
					indiceMiniMax = i;
				}
			}
		}
	}
	
	public void setPossibilite(int numCoup, CelluleChoix c){
		possibilite[numCoup] = c;
	}
	
	public int getIndiceMiniMax(){
		return indiceMiniMax;
	}
	public void setIndiceMiniMax(int indice){
		indiceMiniMax=indice;
	}	
	public void afficher(CelluleChoix c, int profondeur){
		//System.out.print("minimax="+miniMax+"\n");
		for (int i=0; i<profondeur; i++)
			System.out.print("\t");
		if (profondeur%2==0)
			System.out.print("(M)");
		else
			System.out.print("(A)");
		System.out.println(" profondeur="+profondeur+" valeur="+c.miniMax);
		for (int i=0; i<Damier.dimensionH; i++){
			if (c.possibilite[i]!=null){
				afficher(c.possibilite[i],profondeur+1);
			}
		}
		System.out.println("");
	}
}
