/** la classe Date
*    ============= 
* @author Dabancourt 
* @version 0.9  du 20/06/2004 
*/ 

package iut.algo;

import java.io.*;


public class Date {  

	// les attributs
	private int jour, mois, annee;

	// les constructeurs
	public Date(){
		jour = 1;
		mois = 1;
		annee = 1970;
	}

	public Date(int jour, int mois, int an){
		this.jour = jour;
		this.mois = mois;
		annee = an;
	}
	
	public Date(Date d){
		this(d.jour, d.mois, d.annee);
	}

	// les mthodes
	
	// les accesseurs
	public int getAnnee(){ return annee;}
	public int getMois() { return mois; }
	public int getJour() { return jour; }
	public void setJour(int jour) { this.jour = jour; } 
	public void setMois(int mois) { this.mois = mois; }
	public void setAnnee(int annee){ this.annee= annee;}
	
	// les autres mthodes
	public String dateEnChaine(){
		return(this.toString());
	}
	
	
	public String toString(){
		return(jour+"/"+mois+"/"+annee);
	}
	
	public boolean estBissextile() {
	
		int reste, DeuxPremierChiffre,siecle ;

		siecle = annee % 100 ;
		DeuxPremierChiffre = annee / 100 ;
		reste = annee % 4 ;

		if ( (DeuxPremierChiffre % 4) == 0 && (siecle == 0) ) 
			return true ;            // les annes 1600, 2000, 2200 ... ne sont pas bissextiles
		if (siecle == 0)  
			return  false ;            // les annes 1800, 1900 ... sont bissextiles
		if ( (reste % 4) == 0 )  
			return  true;            // les annes divisibles par 4 sont bissextiles
		return false;
	}
	 
	public boolean  precede(Date DateParam ) {
		if (annee < DateParam.annee)  
			return true ;	
		if (annee==DateParam.annee && mois < DateParam.mois )  
			return true ;	   // mme anne, comparaison des mois
		if (annee==DateParam.annee && mois==DateParam.mois && jour < DateParam.jour)  
			return true ;   // mme anne et mme mois, comparaison des jours

		return false ;
	}
	
	public boolean estEgale(Date DateParam) {
		return (jour==DateParam.jour && mois==DateParam.mois && annee==DateParam.annee);
	}
	
	
	public String dateEnChaineComplete( ) {
		String resultat, chaineTemp;

		// resultat = new String();	// initialisation inutile en java
		// chaineTemp = new String();	// initialisation inutile en java
		resultat=" "+ jour ;
		chaineTemp=" ";

		if (mois == 1) chaineTemp=" Janvier ";
		if (mois == 2) chaineTemp=" Fevrier ";		
		if (mois == 3) chaineTemp=" Mars ";
		if (mois == 4) chaineTemp=" Avril ";
		if (mois == 5) chaineTemp=" Mai ";		
		if (mois == 6) chaineTemp=" Juin ";
		if (mois == 7) chaineTemp=" Juillet ";
		if (mois == 8) chaineTemp=" Aout ";		
		if (mois == 9) chaineTemp=" Septembre ";
		if (mois == 10) chaineTemp=" Octobre ";
		if (mois == 11) chaineTemp=" Novembre ";		
		if (mois == 12) chaineTemp=" Dcembre ";		

		resultat = resultat + chaineTemp;
		chaineTemp = " "+ annee;
		resultat = resultat + chaineTemp;


		return resultat ;
	}
	
	
}
