/** utilisation-de-la-classe-Date
*    ============= 
* @author Dabancourt 
* @version 0.9  du 20/06/2004 
*/ 


public class VecteurEntier 
{  

	protected int[] tab;
	protected int taille;
	
	public VecteurEntier()
	{
		this.taille = 5 ;	// l'attribut taille a une valeur
		this.tab = new int[5] ;	// l'attribut tab est initialis
	}
	
	public VecteurEntier(int taille)
	{
		this.taille = taille ;	// l'attribut taille a une valeur
		this.tab = new  int[taille] ;	// l'attribut tab est initialis
	}
	
	public VecteurEntier(VecteurEntier v)
	{
	 	this(v.taille);
	 	
	 	// les attribut tab et taille sont maintenant initialiss
		int i;
	 	for (i=0; i<taille; i++){
	 		this.tab[i] = v.tab[i];
	 	}
	}
	
		
	public void setEntierAt(int nb,int position) 
	{
		this.tab[position] = nb ;
	}
	
	
	
	public int getEntierAt(int position)
	{
		return (this.tab[position]);
	}
	
	public int getTaille()
	{
		return (this.taille);
	}
	
	public void echanger (int pos1, int pos2)
	{
		int tmp;

		tmp = tab[pos1] ;
		tab[pos1] = tab[pos2] ;
		tab[pos2] = tmp ;
	}
	
	
	/******************************************
	 *    les algorithmes de tri              *
	 ******************************************/
	 
	 public String toString(){
	 	int i;
	 	String res="[ ";
	 	
	 	for (i=0; i<taille; i++){
	 		res = res + " - " + tab[i];
	 		System.out.print("*");
	 	}

	 	return (res+"]");
	 }
	 
	 public void remplirHasard(){
	 	int i;
	 	
	 	for (i=0; i<taille; i++)
	 		tab[i] = (int)(100*Math.random());
	 }	
	  
	/**********************************
	 *  recherche Dichotomique		  *
	 **********************************/	 
	public int rechercherDicho(int x)
	{
		// retourne la position de la valeur cherche
		int gauche, milieu, droite;
	 	boolean	trouve;
	
		gauche  = 0 ;
		droite = taille - 1 ;
		milieu = (gauche+droite)/2 ; 		// division entire pour trouver le milieu
		trouve = false ;
		
		while ( (gauche<=droite ) && (trouve==false) )	
		 	// if on ne trouve rien,  un moment on a gauche = droite
		{
			milieu  = (gauche+droite) / 2 ;			// recalcule le milieu (DIV)
			trouve  = ( tab[milieu] == x ) ;			// on a trouv l'lment ?
			
			if ( x > tab[milieu] ) 			// l'lment est  droite du milieu
			 	gauche = milieu + 1 ;
			else					// else, il est  gauche du milieu
			 	droite = milieu - 1 ;
		}
		if (trouve == true)
		 	return milieu ;				// on sort
		else
		 	return(-1) ; 				// lment introuvable : on sort
	}

	public int rechercherDichoRecursif(int x)
	{
		return (rechercherDichoRecursif (x, 0, taille-1) );
	}


	private int rechercherDichoRecursif(int x, int gauche, int droite)
	{

		int milieu;

		milieu = (gauche+droite)/2 ; 		// division entire pour trouver le milieu

		if (tab[milieu] == x) 			// deux conditions d'arrt
			return (milieu) ;
		if (droite <= gauche ) 
			return (-1) ;

		if ( x < tab[milieu] )			// appels rcursifs
		 	return( rechercherDichoRecursif (x, gauche, milieu-1) ) ;
		else					// sinon, il est  droite du milieu
			return( rechercherDichoRecursif (x, milieu+1, droite) ) ;
	}

	 	 
	/**************************
	 *  le tri slection	  *
	 **************************/
	public void triSelection ()
	{
		int indice, indiceNonTrie, posMinimum;
		// indice, indiceNonTrie et posMinimum sont des indices
		int minimum;
		// minimum est une valeur

		indice = 0;	// autant d'itration que d'lments dans le tableau
		while ( indice < taille ) 
		{
			minimum = tab[indice];
			posMinimum = indice;

			// boucle de recherche du minimum
			indiceNonTrie  = indice;
			while (indiceNonTrie < taille)
			{
				if ( tab[indiceNonTrie] < minimum) 
				{
					minimum = tab[indiceNonTrie] ;
					posMinimum  = indiceNonTrie;
				}
				indiceNonTrie = indiceNonTrie + 1 ;
			}
			echanger(posMinimum, indice) ;
			indice = indice + 1 ;
		}
	}

	/**************************
	 *  le tri insertion	  *
	 **************************/
	public void triInsertion ()
	{
		int indice, indiceInserer;
		// indice, indiceNonTrie et posMinimum sont des indices
		int valeurAInserer;	// valeurAInserer est une valeur

        indice = 1;
        while (indice < taille)
        {
        	valeurAInserer = tab[indice];
			indiceInserer = indice-1;

        	while ( (indiceInserer >= 0)&&(valeurAInserer<=tab[indiceInserer]) ) 
			{
				tab[indiceInserer+1] = tab[indiceInserer] ;
				indiceInserer = indiceInserer - 1 ;
			}
			tab[indiceInserer+1] = valeurAInserer;
			
        	indice = indice + 1;
        }
	}
	
	/**************************
	 *  le tri Bulle		  *
	 **************************/
	public void triBulle ()
	{

		int nbIteration,indice;
	
		boolean pasEncoreTrie;
	
		pasEncoreTrie = true;
		nbIteration = taille - 1 ;
		while ( pasEncoreTrie == true ) 
		{
			indice = 0 ;		// parcours du tableau non tri !!
			pasEncoreTrie = false;	// on suppose que tab est compltement tri
			
			while(indice < nbIteration)	// pour faire descendre le + lourd
			{
				if ( tab[indice] >= tab[indice+1] )
				{
					echanger(indice,indice+1) ;		// on change 
					pasEncoreTrie = true ;			// on a fait un change : il n'tait pas compltement tri
				}
				indice =  indice + 1 ;
			}
			nbIteration = nbIteration - 1;		// on recommence de l'indice 0  nbIteration-1
		}			// sauf si la variable pasEncoreTrie toujours Vrai : tab compltement tri !
	}	
	
	
	
	/**************************
	 *  le tri fusion		  *
	 **************************/
    public void triFusion()
	{
		triFusion(0,taille-1);
	}

    private void triFusion(int debut,int fin)
	{
		int milieu;
		
		if (debut!=fin)
		{
			milieu=(fin+debut)/2;
			
			triFusion(debut,milieu);
			triFusion(milieu+1,fin);
			
			fusion(debut,milieu,fin);
		}
	}

	private void fusion(int debut1,int fin1,int fin2)
	{
		int debut2;
		int tabTemp[];
		int compt1;
		int compt2;
		int i;
		
		tabTemp = new int[fin1-debut1+1];
		debut2=fin1+1;
		
		//on recopie les lments du dbut du tableau
		for(i=debut1;i<=fin1;i++)
		{
			tabTemp[i-debut1]=tab[i];
		}
		
		compt1=debut1;
		compt2=debut2;
		i = debut1;
		
		while (	 (i<=fin2)&& (compt1!=debut2))
		{
			if (compt2==(fin2+1)) //c'est que tous les lments du second tableau ont t utiliss
			{
				tab[i]=tabTemp[compt1-debut1]; //on ajoute les lments restants du premier tableau
				compt1++;
			}
			else if (tabTemp[compt1-debut1]<tab[compt2])
			{
				tab[i]=tabTemp[compt1-debut1]; //on ajoute un lment du premier tableau
				compt1++;
			}
			else
			{
				tab[i]=tab[compt2]; //on ajoute un lment du second tableau
				compt2++;
			}
			i = i + 1;
		}
	}

	
	/**************************
	 *  le tri rapide		  *
	 **************************/
    private int placePivot(int debut, int fin)
    {
        int indicePivot, indiceGauche, indiceDroite;
        int valeurPivot;
        boolean pasPlace;
        
        indicePivot = debut;
        valeurPivot = tab[indicePivot];
        
        indiceGauche= debut+1-1;
        indiceDroite= fin+1;

		pasPlace = true;
		
        while (pasPlace)
        {   
        
			indiceGauche = indiceGauche + 1 ;
			while ( (indiceGauche<=fin) && (valeurPivot > tab[indiceGauche]) ){ 
				indiceGauche = indiceGauche + 1 ;
			}
			
			indiceDroite = indiceDroite - 1 ;
			while ( (valeurPivot < tab[indiceDroite]) ){
				indiceDroite = indiceDroite - 1 ;
			}
			
			if (indiceGauche<=indiceDroite){
				echanger(indiceGauche,indiceDroite);
			}else{
				pasPlace = false;
			}
		}
		
		echanger(indicePivot,indiceDroite);
		return indiceDroite ;
    }
    
    private void triRapide(int debut, int fin)
    {	int indicePivot;
    	
        if (fin <= debut){
        	return ;		// entre debut et fin, il reste 0 ou 1 lment : on a fini !
    	}
     
        indicePivot = placePivot(debut,fin);  	// pivotage du tableau 
        triRapide(debut, indicePivot-1) ;		// tri rccursif de la partie gauche de tab[debut-fin]
        triRapide(indicePivot+1, fin);			// tri rccursif de la partie droite de tab[debut-fin]
    }		
		
	public void triRapide()
	{
		triRapide(0,taille-1);
	}	
	
	
	
}	// fin de la classe VecteurEntier
