/**
 * Classe ListeReel
 * Une ListeReel est constue de CelluleReel.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */

public class ListeReelPlus
{


	private CelluleReel tete;
	private CelluleReel courant;
	int longueur;


	public ListeReelPlus() 
	{
		tete = null ;
		courant = null;
	}

/////////////////////////////////
// on ajoute la mthode de construction par recopie 
	public ListeReelPlus(ListeReelPlus lst) {
		
		lst.razCourant() ;

		while ( lst.enFinCourant() != true  ) 
		{
			ajouterTete( lst.getCourant() );
			lst.nextCourant() ;
		}
		razCourant();
	}
/////////////////////////////////
	

	public boolean estVide ( ) 
	{
		return(tete == null);
	}


	public void ajouterTete (float e )
	{
		CelluleReel nouv_cel;
	
		nouv_cel = new CelluleReel(e, tete) ;   // la nouvelle cellule pointe comme tte, et contient llment e.
		tete = nouv_cel ;
	}


	public void ajouterQueue (float e) 
	{
                CelluleReel ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleReel (e, null ) ;
		ptr.setSuivant(nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleReel ptr;
		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null) ;
	}
	
	
	public void afficher ( ) 
	{
		CelluleReel ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		System.out.println("***");
	}
	
	
/////////////////////////////////
// on ajoute quelques mthodes (gestion du courant)


	public float getCourant() {
		return courant.getValeur();
	}


	public boolean enFinCourant() {	// permet de savoir si courant est arriv au bout de la liste !
		if (courant ==null)	// on aurait pu imaginer  la place que 
					// la mthode nextCourant retourne un boolen.
			return true;
		else
			return false;
	}

	public void razCourant() {
		courant=tete;
	}

	public void nextCourant() {
		courant=courant.getSuivant();
	}


	public int size(){
		
		int indice;
		CelluleReel c;
		
		indice = 0;
		c=courant;	// sauvegarde
		
		razCourant();
		while(enFinCourant() != true)
		{
			nextCourant();
			indice =indice + 1;
		}
			
		courant = c;	// on remet la sauvegarde
		return indice;
		
	}



}

