/**
 * Classe ListeDate
 * Une ListeDate est constue de CelluleDate.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */
 
import iut.algo.Date;

public class ListeDate
{


	private CelluleDate tete;
	
	public ListeDate ( ) 
	{
		tete = null ;
	}


	public boolean estVide ( ) 
	{
		return(tete == null);
	}



	public void ajouterTete (Date e )
	{
		CelluleDate nouvCel;
	
		nouvCel = new CelluleDate(e, tete) ;   // la nouvelle cellule pointe comme tte, et contient llment e.
		tete = nouvCel ;
	}


	public void ajouterQueue (Date e) 
	{
		CelluleDate ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleDate (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleDate ptr;
		
		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	
	public boolean contient(Date x) 
	{
		CelluleDate iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if ( iterateur.getValeur().estEgale(x) ) 
				return true;		// on quitte la mthode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}
	
	
	public void afficher ( ) 
	{
		CelluleDate ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		System.out.println("***");
	}
}

