package iut.algo;

import java.util.*;
import iut.algo.Noeud;
import iut.algo.ListeNoeud;


public class ArbreBinaireEntier{

	protected Noeud racine;
	protected int taille;
	protected int hauteur;


	public ArbreBinaireEntier(){	// un arbre vide
		racine=null; 
		taille=0;
		hauteur=0;
	}


	public ArbreBinaireEntier(int valeur){	// un arbre avec une valeur
		this.racine = new Noeud(valeur);
		taille = 1;
		hauteur = 0;  
	}


	public ArbreBinaireEntier(int valeur, ArbreBinaireEntier gauche, ArbreBinaireEntier droit){ 

		this.racine = new Noeud(valeur,gauche,droit);
				
		int hg=0, hd=0;         // pour calculer la hauteur de l'arbre
		if (racine.getGauche() != null){
			taille = taille + racine.getGauche().taille;
			hg = racine.getGauche().hauteur;    // hauteur de l'arbre gauche
		}
		if (racine.getDroit() != null){
			taille = taille + racine.getDroit().taille;
			hg = racine.getDroit().hauteur;    // hauteur de l'arbre droit
		}
		
		if (hg > hd)
			hauteur = hauteur + hg + 1;
		else
			hauteur = hauteur + hd + 1; // hauteur= celle du plus grand sous-arbre
	}
	
	
	public Noeud getRacine(){		return racine;}
	public ArbreBinaireEntier getDroit(){		return racine.droit;}
	public ArbreBinaireEntier getGauche(){	return racine.gauche;}
	public int size(){			return taille;}
	public int getHauteur(){		return hauteur;}
	
 
/*	public String toString(){ 
		String s="";
		
		if (racine !=null) { 
			s = "[" + (racine.getGauche()).toString()+"]"; 
			s = s + " "+ racine.getValeur()+ " "; 
			s = s + "["+ (racine.getDroit()).toString()+"]"; 
			return s ; 
		} 
		else 
			return (""); 
	} 
*/
	/*******************************
	 * les parcours                *
	 *******************************/
	 	
	public void parcoursPrefixe() {
		System.out.println("parcours Prefixe");
		parcoursPrefixe(this);
	}
	
	public void parcoursPrefixe(ArbreBinaireEntier ab) 
	{
		System.out.println(ab.getRacine().getValeur());					// traitement
		if (ab.getGauche() != null) parcoursPrefixe(ab.getGauche());	// appel rcursif
		if (ab.getDroit()  != null) parcoursPrefixe(ab.getDroit());		// appel rcursif
	}
	
	/*******************************/
	public void parcoursInfixe() {
		System.out.println("parcours Infixe");
		parcoursInfixe(this);
	}
	
	public void parcoursInfixe(ArbreBinaireEntier ab) 
	{
		if (ab.getGauche() != null) parcoursInfixe(ab.getGauche());	// appel rcursif
		System.out.print("*");
		System.out.println(ab.getRacine().getValeur());				// traitement
		if (ab.getDroit()  != null) parcoursInfixe(ab.getDroit());	// appel rcursif
	}
	
	/*******************************/
	public void parcoursSuffixe() {
		System.out.println("parcours Suffixe");
		parcoursSuffixe(this);
	}
	
	public void parcoursSuffixe(ArbreBinaireEntier ab) 
	{
		if (ab.getGauche() != null) parcoursSuffixe(ab.getGauche());// appel rcursif
		if (ab.getDroit()  != null) parcoursSuffixe(ab.getDroit());	// appel rcursif
		System.out.println(ab.getRacine().getValeur());				// traitement
	}
	
	/*******************************/
	public void parcoursLargeur() // pas recursif !
	{
		Noeud n;
		
		System.out.println("parcours Largeur");
		
		ListeNoeud liste = new ListeNoeud();
		liste.ajouterTete(getRacine());	
		
		while (liste.estVide() == false){
			n = liste.retirerQueue(0);
			System.out.println(n.getValeur());
			if (n.getGauche() != null) liste.ajouterTete(n.getGauche().getRacine());
			if (n.getDroit()  != null) liste.ajouterTete(n.getDroit().getRacine());
		}		
	}
}