/**
 * Classe ListeArbreBinaireEntier
 * Une ListeArbreBinaireEntier est constue de CelluleArbreBinaireEntier.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */
package iut.algo;

import java.util.*;
import iut.algo.ArbreBinaireEntier;

public class ListeArbreBinaireEntier
{


	private CelluleArbreBinaireEntier tete;
	
	public ListeArbreBinaireEntier ( ) 
	{
		tete = null ;
	}


	public boolean estVide ( ) 
	{
		return(tete == null);
	}



	public void ajouterTete (ArbreBinaireEntier e )
	{
		CelluleArbreBinaireEntier nouvCel;
	
		nouvCel = new CelluleArbreBinaireEntier(e, tete) ;   // la nouvelle cellule pointe comme tte, et contient llment e.
		tete = nouvCel ;
	}


	public void ajouterQueue (ArbreBinaireEntier e) 
	{
		CelluleArbreBinaireEntier ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleArbreBinaireEntier (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleArbreBinaireEntier ptr;
		
		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	public ArbreBinaireEntier retirerQueue (int i) 
	{
		CelluleArbreBinaireEntier ptr, dernier;
		
		ptr = tete;
		
		if (tete==null)	// erreur
			return null;
			
		if (tete.getSuivant()==null){
			dernier = tete;
			tete=null;
		}
		else
		{
			while ( ptr.getSuivant().getSuivant() != null) 
			{
				ptr = ptr.getSuivant();
			}
			dernier = ptr.getSuivant();
			ptr.setSuivant(null);
		}
		return dernier.getValeur();
	}
	
	public boolean contient(ArbreBinaireEntier x) 
	{
		CelluleArbreBinaireEntier iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() == x) 
				return true;		// on quitte la mthode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}
	
	
	public void afficher ( ) 
	{
		CelluleArbreBinaireEntier ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		System.out.println("***");
	}
}

