/** la classe Graphe
*    ============= 
* @author Dabancourt 
* @version 0.9  du 20/06/2004 
*/ 

package iut.algo;

import java.io.*;



public class Graphe
{
	private int [][] tab;
 	private int nbSommet;

	public Graphe(int nbSommet)
	{	int ligne, col;
	
		this.nbSommet = nbSommet ;
		this.tab = new int[nbSommet][nbSommet] ;
		
		for (ligne = 0; ligne < nbSommet; ligne ++){
			for (col = 0; col < nbSommet; col ++){
				tab[ligne][col]=0;
			}	
		}
	}

	public void ajouterArc (int noeudDebut, int noeudFin)
	{
		tab[noeudDebut-1][noeudFin-1]=1;
		tab[noeudFin-1][noeudDebut-1]=1;
	}


	public String toString() 
	{	int ligne, col;
		String res;
		
		res="";
		for (ligne = 0; ligne < nbSommet; ligne ++){
			for (col = 0; col < nbSommet; col ++){
				res = res + "\t" + tab[ligne][col];
			}	
			res = res + "\n";
		}
		return res;
	}

	public void Floyd() 
	{	int [][] floyd;
		int ligne, col;
		int infini = Integer.MAX_VALUE;
		
		
		int k,i,j;
		int dik, dkj, u;
		
		floyd = new int[nbSommet][nbSommet];
		for (ligne = 0; ligne < nbSommet; ligne ++){
			for (col = 0; col < nbSommet; col ++){
				if (tab[ligne][col]==0)
					floyd[ligne][col]=infini;
				else
					floyd[ligne][col]=tab[ligne][col];
			}	
		}

		for (k=0; k<nbSommet; k++)
			for (i=0; i<nbSommet; i++)
				for (j=0; j<nbSommet; j++)
				{
					dik=floyd[i][k];
					dkj=floyd[k][j];
					
					if (dik!=infini && dik!=infini)
					{	u = dik + dkj;
						if (u<floyd[i][j])
							floyd[i][j]=u;
					}
				}
		System.out.println(floyd);
	}
	
	private int degre(int sommet){
		int degre = -1;	// on enleve le noeud sur lui-meme
		for (int i =0; i<nbSommet; i++){
			if (tab[sommet][i]!=0)
				degre++;
		}
		return(degre);
	}
	
	public void colorer(){
		int [] couleur = new int[nbSommet];
		int [] degre = new int[nbSommet];

		int nbSommetColorise;
		int nouvelleCouleur = 0;
		int	indicedegreMax;
		int	degreMax;
		
		for (int i =0; i<nbSommet; i++){
			couleur[i]=0;
			degre[i] = this.degre(i);
		}

		nbSommetColorise = 0;
		while (nbSommetColorise <nbSommet){
			
			// nouvelle couleur
			nouvelleCouleur++;
			
			// on recherche le degr max
			// d'un sommet sans couleur
			indicedegreMax = -1;
			degreMax = 0;
			for (int i =0; i<nbSommet; i++){
				if (couleur[i]==0 && degreMax<degre[i]){
					indicedegreMax = i;
					degreMax = degre[i];
				}
			}
			
			// on met le degreMax  la nouvelle couleur
			couleur[indicedegreMax]=nouvelleCouleur;
			nbSommetColorise++;		
			
			// et tous les sommets non coloriss
			// qui ne sont pas adjacent  indicedegreMax
			for (int i=0; i<nbSommet; i++){
				if (couleur[i]==0 && tab[i][indicedegreMax]==0){
					couleur[i]=nouvelleCouleur;
					nbSommetColorise++;		
				}
			}
		
		}
		for (int i=0; i<nbSommet; i++){
			System.out.println("i="+i+" "+couleur[i]);
		}
	}	
}