/** Classe Grille
* ============
*@ author Dabancourt
*@ version du 26/04/03
*/

import java.util.Stack;



class  Grille{
  
	// dclaration des attributs:
	static int dimensionH=8;	// largeur du Grille=8
	static int dimensionV=6;	// hauteur du Grille=6
	static int taille=4;		// nombre de pion  aligner=4
	int place[]; 
	Pion tab[][];
	
	int examen;		// entier qui juge le Grille
	int gagnant;
	int nbCaseLibre;
	Stack memoire;
		
	// dclaration des constructeurs:
	public Grille(){
		gagnant = 0;	// personne ne gagne au debut !!!
		nbCaseLibre=dimensionH*dimensionV;
		place = new int [dimensionH];  	// si place[2]=1, la prochaine fois qu'on joue en 2, 
						// le pion ira sur la ligne 1
		for (int i=0; i<dimensionH; i++) place[i]=0;
		
		tab=new Pion[dimensionH][dimensionV];
		init();
		memoire=new Stack();
		examen=0;
	}
	// dclaration des methodes:
	private void init(){
		for (int lig=0; lig<dimensionV; lig++)
			for (int col=0; col<dimensionH; col++)
				tab[col][lig]=null;
	}
	
	public boolean estFini(){ return ((gagnant != 0)||(nbCaseLibre==0));}
	
	public boolean coupValide(int coup){ 
		if ((coup<0) || (coup>=dimensionH))
			return false;
		return (place[coup]<dimensionV);
	}
	
	public String toString(){
		String s="";
		for (int col=0; col<dimensionH; col++)
			s+="-"+col;
		s+="-\n";
		for (int col=0; col<dimensionH; col++)
			s+="--";
		s+="-\n";
		for (int lig=dimensionV-1; lig>=0; lig--){
		//for (int lig=4-1; lig>=0; lig--){
			for (int col=0; col<dimensionH; col++)
				if (tab[col][lig]!=null)
					s+="|"+tab[col][lig].toString();
				else
					s+="| ";
			s+="|\n";
			for (int col=0; col<dimensionH; col++)
				s+="--";
			s+="-\n";
		}
		return s;
	}

	public boolean deplacement(int coup, Joueur joueur){	// on peut jouer
		if (place[coup]==dimensionV)
			return false;
		// on peut jouer !
		
		tab[coup][place[coup]]=new Pion(new Position(coup,place[coup]),joueur.getCouleur());
		place[coup]=place[coup]+1;

		memoire.push(new Integer(coup));
		// donne une valeur au jeu !
		examen = examine();
		nbCaseLibre--;
		
		return true;
	}
	
	// a appeler uniquement apres deplacement !!
	public boolean estGagnant(){ return (gagnant!=0);}

	public boolean annuler(){
		if (memoire.empty())
			return false;
		int coup = ((Integer)memoire.pop()).intValue();
		place[coup]--;
		tab[coup][place[coup]]=null;
		nbCaseLibre++;
		gagnant=0;
		return true;
	}
	

	/*******************************************
	 examen de la Grille : juger les positions !!
	 *******************************************/
	public int getExamen(Joueur j){
		return (examen*j.getCouleur());
	}
	 
	public int examine(){
		int [][] potentiel = new int[2][taille+1];
		for (int i=0; i<taille+1; i++){
			potentiel[0][i]=0;	// joueur qui joue le 2eme(-1)
			potentiel[1][i]=0;	// joueur qui joue le 1er (+1)
		}
		
		// remplir le tableau "potentiel"
		for (int lig=dimensionV-1; lig>=0; lig--){
			for (int col=0; col<dimensionH; col++){
				examine(potentiel,new Position(col,lig));
				// amelioration : on arrete si 4 alignes
				if (potentiel[0][taille]>0){
					gagnant=-1;
					return (-100000);
				}
				if (potentiel[1][taille]>0){
					gagnant=1;
					return (100000);
				}
			}
		}
				
		// transformer le tableau "potentiel" en une seule valeur	
		int puissance10=1;
		int valeur=0;
		for (int col=1; col<taille; col++){
			valeur = valeur + potentiel[1][col] * puissance10;
			valeur = valeur - potentiel[0][col] * puissance10;
			puissance10 = 20*puissance10;
		}
		// quatre align : c'est fini !
		valeur = valeur + potentiel[1][taille] * 100000;
		valeur = valeur - potentiel[0][taille] * 100000;
		
		// evaluation pour le 1er joueur !
		//return (valeur*joueur.getCouleur());
		return (valeur);
	}
	
	public void examine(int[][] potentiel, Position p){
		int ex;
		ex=examine(p,1,0);	// -
		if (ex<0)	potentiel[0][-ex]++;
		if (ex>0)	potentiel[1][ex]++;
		
		ex=examine(p,1,1);	// /
		if (ex<0)	potentiel[0][-ex]++;
		if (ex>0)	potentiel[1][ex]++;
		
		ex=examine(p,1,-1);	// \
		if (ex<0)	potentiel[0][-ex]++;
		if (ex>0)	potentiel[1][ex]++;
		
		ex=examine(p,0,1);	// !
		if (ex<0)	potentiel[0][-ex]++;
		if (ex>0)	potentiel[1][ex]++;
	}	
	
	public int examine(Position p, int dx, int dy){
		int vide = 0;
		int nbCase = 1;
		int couleur ;
		
		if (new Position(p.getX()+dx*(taille-1), p.getY()+dy*(taille-1)).estValide(this)==false)
			return 0;
		
		// on cherche la couleur !
		int i=0;
		while ( (i<taille) && (tab[p.getX()+dx*i][p.getY()+dy*i]==null) )
			i++;
			
		if (i==taille)
			return 0;
			
		couleur = tab[p.getX()+dx*i][p.getY()+dy*i].getCouleur();
		nbCase=1;
		
		//System.out.println(dx+" , "+dy);
		for (int j=i+1; j<taille; j++)
		{
			if (tab[p.getX()+dx*j][p.getY()+dy*j]==null)
				vide++;
			else if (tab[p.getX()+dx*j][p.getY()+dy*j].getCouleur()==couleur)
				nbCase++;
			else
				return 0;
		}
		
		return (nbCase*couleur);
	}
}
