package com.wiley.tomcatbook;

import java.util.*;
import javax.servlet.*;

public class SampleLifecycleListener implements
  ServletContextListener
{
  public void contextInitialized(ServletContextEvent event)
  {
    System.out.println("Contexte de servlet initialis ! " + event);
    enumerateContextAttributes(event.getServletContext());
  }

  public void contextDestroyed(ServletContextEvent event)
  {
    System.out.println("Contexte de servlet dtruit ! " + event);
    enumerateContextAttributes(event.getServletContext());
  }

  public final void enumerateContextAttributes
(  ServletContext context)
  {
    Enumeration e = context.getAttributeNames();
    while(e.hasMoreElements())
    {
      System.out.println("\tAttribute: " + e.nextElement());
    }
  }
}
