package com.wiley.tomcatbook;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.util.*;
import java.text.*;

public class SelectTag extends BodyTagSupport
{

  protected String name = null;
  protected String defaultvalue = null;
  protected String size = "1";

  public int doStartTag() throws JspException
  {

    try
    {
      JspWriter out = pageContext.getOut();

      out.println("<select name=\""
      + name
      + "\" size=\""
      + size
      + "\" >");

    }
    catch (Exception ex)
    {
    throw new JspTagException("SelectTag: " +
      ex.getMessage() );
    }
    return EVAL_BODY_TAG;
  }

  public int doEndTag() throws JspTagException {

    try
    {
      JspWriter out = pageContext.getOut();
      out.println("</select>");
    }
    catch (Exception ex)
    {
      throw new JspTagException("SelectTag: " +
        ex.getMessage());
    }

    return EVAL_PAGE;
    }

  public int doAfterBody() throws JspTagException
  {

    try {

    BodyContent bodyContent = getBodyContent();
      String options = bodyContent.getString();
      String nextOption = null;

      bodyContent.clearBody();
      JspWriter writer = bodyContent.getEnclosingWriter();

      int offset = 0;
      int next = 0;

      while( next != -1 ) {
        next = options.indexOf( ",", offset );
        if (next != -1) {
          nextOption = options.substring(offset, next);
        }
        else {
          nextOption = options.substring(offset);
        }
        writer.print( "<option value=\""
        + nextOption
        + "\">"
        + nextOption
        + "</option>" );
        offset = next + 1;

      }

    }
    catch (Exception ex) {
      throw new JspTagException("SelectTag: " +
        ex.getMessage() );
    }

    return SKIP_BODY;
  }

  public String getName() {
    return (this.name);
  }

  public void setName( String parameter ) {
    this.name = parameter;
  }

  public String getDefault() {
    return (this.defaultvalue);
  }

  public void setDefault( String parameter ) {
    this.defaultvalue = parameter;
  }

  public String getSize() {
    return (this.size);
  }

  public void setSize( String parameter ) {
    this.size = parameter;
  }

}
