package bean;
import java.sql.*;

public class Employee implements java.io.Serializable{
    
    private String firstName;    
    private String lastName;
    private String phone;
    private int id;
    private int deptId;    
    
    private static final String insert = 
        "insert into employee (fname, lname, phone, deptid) values (?,?,?,?)";
    
    private static final String delete = 
        "delete from employee where empid=";
    
    private static final String select = 
            "select empid, fname, lname, phone, deptid from employee where empid=";
            
        
    
    public Employee() {
    }
    
    public Employee(ResultSet rs) throws SQLException{
        init(rs);
    }
    
    public void init(ResultSet rs) throws SQLException{
        this.firstName = rs.getString("fname");
        this.lastName = rs.getString("lname");
        this.phone = rs.getString("phone");
        this.id = rs.getInt("empid");
        this.deptId = rs.getInt("deptid");
    }
    
    
    public Employee(int id) throws SQLException{
        load(id);
    }
    
    
    
    
    public String getFirstName() {
        return this.firstName;
    }    
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }    
    
    public String getLastName() {
        return this.lastName;
    }
    
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    
    public String getPhone() {
        return this.phone;
    }
    
    public void setPhone(String phone) {
        this.phone = phone;
    }
    
    public int getId() {
        return this.id;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public int getDeptId() {
        return this.deptId;
    }
    
    public void setDeptId(int deptId) {
        this.deptId = deptId;
    }
    
    public void remove() throws Exception{
        Connection connection = null;
        Statement statement = null;
        
        
        try{
        
            connection = Dept.getConnection();
            statement = connection.createStatement();

            System.out.println(delete+id);
            int worked = statement.executeUpdate(delete+id);
            if (worked != 1) throw new RuntimeException("Unable to delete the employee");
            

        }finally {
            if (statement!=null) statement.close();
            if (connection!=null) connection.close();
        }
    }
    
    public void add() throws SQLException{
        Connection connection = null;
        PreparedStatement statement = null;
        
        
        try{
        
            connection = Dept.getConnection();
            statement = connection.prepareStatement(insert);
            
            //fname, lname, phone, deptid
            statement.setString(1, this.firstName);
            statement.setString(2, this.lastName);
            statement.setString(3, this.phone);
            statement.setInt(4, this.deptId);
            
            
            int worked = statement.executeUpdate();
            if (worked != 1) throw new RuntimeException("Unable to add the employee");

        }finally {
            if (statement!=null) statement.close();
            if (connection!=null) connection.close();
        }
        
    }
    
    public void load() throws SQLException{
        load(this.id);
        
    }
    public void load(int id) throws SQLException{

        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
                
        try{
        
            connection = Dept.getConnection();
            statement = connection.createStatement();
            
            resultSet = statement.executeQuery(select+id);

            if(resultSet.next()){
                init(resultSet);
            }else{
                throw new RuntimeException("Unable to load employee id=" + id);
            }
            
        }finally {
            if (resultSet!=null) resultSet.close();
            if (statement!=null) statement.close();
            if (connection!=null) connection.close();
        }
        
        
    }
    
    public void edit() throws Exception{
        remove();
        add();
        
    }
    
    public static void main(String[] args) throws SQLException{
    }

}
