import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.velocity.*;
import org.apache.velocity.context.*;
import org.apache.velocity.servlet.*;
import org.apache.velocity.app.*;
import org.apache.velocity.exception.*;

public class VelocityAdd extends VelocityServlet
{
    protected Properties loadConfiguration( ServletConfig config )
      throws IOException, FileNotFoundException {

     Properties p = new Properties();

     String path = config.getServletContext().getRealPath("/");

     if (path == null) {
      System.out.println("VelocityAdd.loadConfiguration() : " +
        "unable to get the current webapp root. Using '/'. " +
        "Please fix.");

      path = "/";
     }

     p.setProperty( Velocity.FILE_RESOURCE_LOADER_PATH, path );
     p.setProperty( "runtime.log", path + "velocity.log" );

     return p;
    }

    public Template handleRequest( HttpServletRequest request,
      HttpServletResponse response, Context ctx )
    {

      Template outty = null;

      try {

        int a = 10;
        int b = 5;
        int c = a + b;

        ctx.put( "a", new Integer( a ) );
        ctx.put( "b", new Integer( b ) );
        ctx.put( "c", new Integer( c ) );
        outty = getTemplate("velocityadd.vm");
      }
      catch( ParseErrorException pee ) {

        System.out.println("VelocityAdd : parse error for template " + pee);
      }
      catch( ResourceNotFoundException rnfe ) {
        System.out.println("SampleServlet : template not found " + rnfe);
      }
      catch( Exception e ) {
        System.out.println("Error " + e);
      }

      return outty;
    }
}
