package com.wiley.tomcatbook.shopping;

import java.util.*;

public class ShoppingCart implements java.io.Serializable
{
    private Map items = new HashMap();

    private ItemHolder getItemHolder(Item item)
    {
      ItemHolder holder = (ItemHolder) items.get(item.getName());
      if (holder == null)
      {
        holder = new ItemHolder();
        holder.setItem(item);
        // La ligne suivante n'est pas ncessaire puisque le nouvel objet
        // holder a un itemCount gal  zro par dfaut,
        // mais est incluse uniquement afin de faciliter la lecture du code.
        holder.setItemCount(0);
        items.put(item.getName(), holder);
      }
      return holder;
    }

    public void addItem(Item item)
    {
      ItemHolder holder = getItemHolder(item);
      holder.setItemCount(holder.getItemCount() + 1);
    }

    public void removeItem(Item item)
    {
      ItemHolder holder = getItemHolder(item);
      holder.setItemCount(holder.getItemCount() - 1);
      if (holder.getItemCount() <= 0)
      {
        items.remove(item.getName());
      }
     }

    public void removeAllOfItem(Item item)
    {
      items.remove(item.getName());
    }

    public Iterator getItemIterator()
    {
      return items.values().iterator();
    }

    public int getSubtotal()
    {
      int subtotal = 0;
      Iterator i = getItemIterator();
      while (i.hasNext())
      {
        ItemHolder holder = (ItemHolder) i.next();
        subtotal += holder.getItemCount()
        * holder.getItem().getUnitPrice();
       }
      return subtotal;
    }
}
