package com.wiley.tomcatbook.shopping;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ShoppingCartExampleServlet extends HttpServlet
{
  Map items = new HashMap();
  public void init(ServletConfig conf)
    throws ServletException
  {
    super.init(conf);
    Item item = new Item();
    item.setName("Tomcat par la pratique");
    item.setUnitPrice(4500);
    items.put(item.getName(), item);
    item = new Item();
    item.setName("Programmation en Java sous OS X");
    item.setUnitPrice(3500);
    items.put(item.getName(), item);
    item = new Item();
    item.setName("Le guide du dveloppeur Java 2");
    item.setUnitPrice(599);
    items.put(item.getName(), item);
  }

  public void doGet(
    HttpServletRequest request,
    HttpServletResponse response
  )
    throws ServletException, IOException
  {
    HttpSession session = request.getSession(true);
    ShoppingCart cart = (ShoppingCart)
      session.getAttribute("example.shopping.cart");
    if (cart == null)
    // c'est--dire qu'aucun panier prcdent
    // n'tait associ  la session
  {
      cart = new ShoppingCart();
      session.setAttribute("example.shopping.cart", cart);
    }
    // Grer toutes les requtes
  String action = request.getParameter("action");
  String itemName = request.getParameter("name");
  Item targetItem = (Item) items.get(itemName);
  if (targetItem != null)
  {
    if ("add".equals(action))
  {
      cart.addItem(targetItem);
  }
  else if ("remove".equals(action))
  {
    cart.removeItem(targetItem);
  }
  else if ("remove-all".equals(action))
  {
    cart.removeAllOfItem(targetItem);
  }
}

ServletOutputStream out = response.getOutputStream();

out.println("<html>");
out.println("<head>");
out.println("<title>Exemple de gestion de panier");
out.println("</title>");
out.println("</head>\n");
out.println("<body>");
out.println("<table width=\"100%\" height=\"100%\">");
out.println("<tr valign=\"top\">\n");
out.println("<!-- Body Content -->");
out.println("<td>");
out.println("<table>\n");

Iterator i = items.values().iterator();
if (i.hasNext())
{

  out.println("<tr>");
  out.println("<td>Article");
  out.println("</td>");
  out.println("<td>Prix");
  out.println("</td>");
  out.println("<td>&nbsp;</td>");
  out.println("<td>&nbsp;</td>");
  out.println("</tr>\n");
  while(i.hasNext())
  {
    Item item = (Item) i.next();
    out.println("<tr>");
    out.println("<td>" + item.getName());
    out.println("</td>");
    out.println("<td align=\"right\">"
      + toCurrency(item.getUnitPrice()));
    out.println(" euros</td>");
    out.println("<td>");
    out.print("<td>[<a href=\"");
    out.print(response.encodeURL("?action=add&name="
      + item.getName()));
    out.println("\">Ajouter au panier</a>]</td>");
    out.print("<td>[<a href=\"");
    out.print(response.encodeURL(
      "?action=remove-all&name="
      + item.getName()));
    out.println("\">Supprimer tous les articles</a>]</td>");
    out.println("</td>");
    out.println("</tr>");
  }
}
out.println("</table>");
out.println("</td>");
out.println("</tr>\n");
out.println("<tr valign=\"top\">\n");
out.println("<!-- Shopping Cart -->");
out.println("<td>");
out.println("<table bgcolor=\"#eeeeee\">");
out.println("<tr>");
out.println("<td colspan=\"7\">Panier :");
out.println("</td>");
out.println("</tr>");
i = cart.getItemIterator();
if (i.hasNext())
{
  out.println("<tr>");
  out.println("<td>&nbsp;</td>");
  out.println("<td>Article</td>");
  out.println("<td>Prix unit.</td>");
  out.println("<td colspan=\"3\">Qt</td>");
  out.println("<td>Prix</td>");
  out.println("</tr>\n\n");
  while(i.hasNext())
  {
    ItemHolder holder = (ItemHolder) i.next();
    out.println("<tr>");
    out.print("<td>[<a href=\"");
    out.print(response.encodeURL(
      "?action=remove-all&name="
      + holder.getItem().getName()));
    out.println("\">x</a>]</td>");
    out.println("<td>" + holder.getItem().getName());
    out.println("</td>");
    out.println("<td align=\"right\">" +
      toCurrency(holder.getItem().getUnitPrice())
    );
    out.println("</td>");
    out.println("<td>" + holder.getItemCount());
    out.println("</td>");
    out.print("<td>[<a href=\"");
    out.print(response.encodeURL("?action=add&name="
      + holder.getItem().getName()));
    out.println("\">+</a>]</td>");
    out.print("<td>[<a href=\"");
    out.print(response.encodeURL("?action=remove&name="
      + holder.getItem().getName()));
    out.println("\">-</a>]</td>");
    out.println("<td align=\"right\">");
    out.println(
      toCurrency(holder.getItem().getUnitPrice()
      * holder.getItemCount())
    );
    out.println(" euros</td>");
    out.println("</tr>\n\n");
    }
  }
  else
  {
    out.println("<tr>");
    out.print("<td colspan=\"7\">[Rien dans le panier]");
    out.println("</td>");
    out.println("</tr>");
    }
    out.println("<tr>");
    out.println("<td colspan=\"6\">Sous total:</td>");
    out.println("<td align=\"right\">"
      + toCurrency(cart.getSubtotal()));
    out.println(" euros</td>");
    out.println("</tr>");
    out.println("</table>");
    out.println("</td>\n");
    out.println("</tr>\n");
    out.println("<tr>\n");
    out.println("<td colspan=\"4\">");
    out.println("<center>Copyright &copy; ");
    out.print((new Date()).getYear() + 1900);
    out.println(" Ma Fabuleuse Enterprise");
    out.println("</center>");
    out.println("</td>");
    out.println("</tr>");
    out.println("</table>");
    out.println("</body>");
    out.println("</html>");
  }

  /**
   * Prend un entier et renvoie une chane reprsentant
   * une valeur exprime en centimes d'euros, et renvoie une chane avec un nombre
   * dcimal insr au bon endroit afin de rendre l'entier
   * sous forme du montant en euros correspondant.
  */
  public static final String toCurrency(int anInt)
  {
    StringBuffer sb = new StringBuffer("" + anInt);
    if (sb.length() > 2)
      sb.insert(sb.length() - 2, '.');
      // Cela fonctionnera pour l'exemple, mais il est prfrable
      // de dfinir un code plus robuste pour un dploiement rel.
    return sb.toString();
  }

}
