package com.wiley.tomcatbook;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class ClientListServlet extends HttpServlet
{

  private Connection con;

  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);
    String driver = config.getInitParameter("database-driver-class");
    String jdbcurl = config.getInitParameter("database-url");
    String login = config.getInitParameter("database-login");
    String password = config.getInitParameter("database-password");
    try
    {
    Class.forName(driver); // Charger le pilote
    con = DriverManager.getConnection(jdbcurl,
        login, password);
    }
    catch (Exception e)
    {
        throw new UnavailableException(e.getMessage());
    }
  }

  public void doGet (HttpServletRequest request,
HttpServletResponse
response)
  throws ServletException, IOException
{
    response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    out.println("<html>");
    out.println("<head>");
    out.println("<title>Liste des clients</title>");
    out.println("</head>");
    out.println("<body>");

    out.println("<h1>Contacts</h1>");
    out.println("<table border=\"1\">");
    out.println("<tr>");
    out.println("<th>Prnom</th>");
    out.println("<th>Nom</th>");
    out.println("<th>Tlphone</th>");
    out.println("</tr>");
    try
    {
        Statement s = con.createStatement();
        ResultSet rs = s.executeQuery("SELECT * FROM client");

          while(rs.next())
        {
          out.println("<tr>");
          out.println("<td>" + rs.getString("first_name") + "</td>");
          out.println("<td>" + rs.getString("last_name") + "</td>");
          out.println("<td>" + rs.getString("phone") + "</td>");
          out.println("</tr>");
          }

        rs.close();
          s.close();

        }
        catch (SQLException sqle) {
          response.sendError(500, "Exception lors de l'accs  la base de donnes: " + sqle);
        }
    out.println("</table>");
    out.println("</body>");
    out.println("</html>");
    }

      public void destroy()
      {
        try
      {
        con.close();
      }
      catch (Exception e)
      {
        // Non.
      }
      super.destroy();
    }
}
