package com.neo.smartobjects;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ObjectFactoryInitializer extends HttpServlet {

  private String status;

  public void init(ServletConfig conf)
          throws ServletException {
    super.init(conf);
    String context = conf.getInitParameter("context");
    String source = conf.getInitParameter("datasource");
    try {
      ObjectFactory.initialize(context, source);
      status = "Object Factory initialized.";
    }
    catch (SmartObjectException soe) {
      status = "Object Factory initialization failed. " + soe;
    }
  }

  public void doGet(HttpServletRequest request, HttpServletResponse
          response)
          throws IOException, ServletException {
    response.setContentType("text/plain");
    ServletOutputStream out = response.getOutputStream();
    out.print(status);
  }
}
