package com.wiley.tomcatbook;

import java.io.*;
import java.net.*;

import junit.framework.*;
import org.xml.sax.*;
import com.meterware.httpunit.*;

public class ClientListServletTest extends TestCase {

  public ClientListServletTest(String name) {
    super(name);
  }

  public void testTableContents()
          throws SAXException, IOException, MalformedURLException {
    WebConversation wc = new WebConversation();
    WebRequest req = new GetMethodWebRequest("http://localhost:8080/tomcatbook/clientlist");
    WebResponse resp = wc.getResponse(req);
    WebTable table = resp.getTables()[0];
    String[][] tableStrings = table.asText();
    assertEquals("First Name", tableStrings[0][0]);
    assertEquals("Last Name", tableStrings[0][1]);
    assertEquals("Phone", tableStrings[0][2]);
    assertEquals("Ian", tableStrings[1][0]);
    assertEquals("McFarland", tableStrings[1][1]);
    assertEquals("+1 415 555 1515", tableStrings[1][2]);
    assertEquals("Peter", tableStrings[2][0]);
    assertEquals("Harrison", tableStrings[2][1]);
    assertEquals("+64 9 555 1551", tableStrings[2][2]);
    assertEquals("Tim", tableStrings[3][0]);
    assertEquals("Ryan", tableStrings[3][1]);
    assertEquals("+1 718 555 5151", tableStrings[3][2]);
  }
}
