/*
* BasicServlet.java
*
*/

package tomcatbook.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.*;
import java.sql.*;
import javax.naming.*;

/**
 *
 * @author Rick Hightower
 *
 * @version 1.0
 * @web:servlet name="BasicServlet"
 display-name="Basic Servlet"
 load-on-startup="1"
 * @web:servlet-init-param name="hi" value="Ant est cool!"
 * @web:servlet-init-param name="bye" value="XDoc c'est super!"
 * @web:resource-ref description="JDBC resource"
 * name="jdbc/mydb"
 * type="javax.sql.DataSource"
 * auth="Container"
 * @web:servlet-mapping url-pattern="/Basic/*"
 * @web:servlet-mapping url-pattern="*.Basic"
 * @web:servlet-mapping url-pattern="/BasicServlet"
 */
public class BasicServlet extends HttpServlet {

  /** Initialise la servlet.
   */
  public void init(ServletConfig config) throws ServletException {
    super.init(config);

  }

  /** Dtruit le servlet.
   */
  public void destroy() {
  }

  /** Traite les requtes des mthodes HTTP <code>GET</code> et
   <code>POST</code>.
   * @param request servlet request
   * @param response servlet response
   */
  protected void processRequest(HttpServletRequest request,
                                HttpServletResponse response)
          throws ServletException, java.io.IOException {
    ServletConfig config = this.getServletConfig();
    String hi = config.getInitParameter("hi");
    String bye = config.getInitParameter("bye");

    try {
      response.setContentType("text/html");
      java.io.PrintWriter out = response.getWriter();
      out.println("<html>");
      out.println("<head>");
      out.println("<title>Basic Servlet</title>");
      out.println("</head>");
      out.println("<body>");
      out.println("<h1> bye:" + bye + "</h1>");
      out.println("<h1> hi:" + hi + "</h1>");
      getJdbcPool(out);
      out.println("</body>");
      out.println("</html>");
      out.close();
    }
    catch (Exception e) {
      throw new ServletException(e);
    }
  }

  /** Gre la mthode HTTP <code>GET</code>.
   * @param request servlet request
   * @param response servlet response
   */
  protected void doGet(HttpServletRequest request,
                       HttpServletResponse response)
          throws ServletException, java.io.IOException {
    processRequest(request, response);
  }

  /** Gre la mthode HTTP <code>POST</code>.
   * @param request servlet request
   * @param response servlet response
   */
  protected void doPost(HttpServletRequest request,
                        HttpServletResponse response)
          throws ServletException, java.io.IOException {
    processRequest(request, response);
  }

  /** Renvoie une brve description de la servlet.
   */
  public String getServletInfo() {
    return "XDoc Rules";
  }

  private void getJdbcPool(java.io.PrintWriter out) throws Exception {
    out.println("</ br>");

    Object obj = new InitialContext().
            lookup("java:comp/env/jdbc/mydb");
    DataSource pool = (DataSource) obj;
    if (pool == null) return;
    Connection connection = pool.getConnection();

    out.println("<table>");
    try {

      ResultSet rs =
              connection.getMetaData().
              getTables(null, null, null, null);
      while (rs.next()) {
        out.println("<tr><td>");
        out.println(rs.getString("TABLE_NAME"));
      }
    }
    finally {
      connection.close();
    }
    out.println("</table>");

    out.println("</ br>");
  }
}
