package xptoolkit.web;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.RequestDispatcher;

/* importer les classes afin de crer un objet message ou un type de message */
import xptoolkit.model.GreetingFactory;
import xptoolkit.model.Greeting;

public class HelloWorldServlet extends HttpServlet {

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    /* Lire le type de message  crer par la fabrique */
    String clazz = config.getInitParameter("Greeting.class");
    if (clazz != null) System.setProperty("Greeting.class", clazz);
  }

  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
          throws ServletException {

    RequestDispatcher dispatch;
    ServletContext context;
    /*Extraire la session, crer un bean de message, le mapper
     dans la session et rediriger vers la JSP Hello World.
    */
    try {

      /* Crer le bean de message et le mapper  la session. */
      HttpSession session = request.getSession(true);
      Greeting greet = (Greeting)
              GreetingFactory.getGreetingFactory().getGreeting();
      session.setAttribute("greeting", greet);

      /* Rediriger vers HelloWorld.jsp */
      context = getServletContext();
      dispatch = context.getRequestDispatcher("/HelloWorldJSP");
      dispatch.forward(request, response);
    }
    catch (Exception e) {
      throw new ServletException(e);
    }
  }

  /* Appeler simplement la mthode doGet */
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
          throws ServletException {
    doGet(request, response);
  }
}
