package com.wiley.tomcatbook;

import javax.servlet.http.*;
import java.util.*;

public class SampleHttpSessionListener implements HttpSessionListener
{
  public void sessionCreated(HttpSessionEvent event)
  {
    HttpSession s = event.getSession();
    System.out.println("Session cre : " + s);
    enumerateSessionAttributes(s);
  }

  public void sessionDestroyed(HttpSessionEvent event)
  {
    HttpSession s = event.getSession();
    System.out.println("Session dtruite : " + s);
    enumerateSessionAttributes(s);
  }
  public final void enumerateSessionAttributes(HttpSession session)
  {
    Enumeration e = session.getAttributeNames();
    while(e.hasMoreElements())
    {
      System.out.println("\tAttribut : " + e.nextElement());
    }
  }
}
