package com.wiley.tomcatbook;

import java.util.*;
import java.text.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class DateSelectTag extends TagSupport
{
  protected String name = null;
  protected String defaultdate = null;
  protected String size = "1";

  public int doStartTag() throws JspException
  {
    try
    {
      JspWriter out = pageContext.getOut();

      // Si la date par dfaut est fournie, utilisez-la ;
      // sinon, utilisez la date actuelle.

      GregorianCalendar calendar = new GregorianCalendar();
      if(defaultdate!=null)
      {
        SimpleDateFormat dateFormat
          = new SimpleDateFormat("MM/dd/yyyy");
        dateFormat.setCalendar(calendar);
        dateFormat.parse(defaultdate);
      }

      int day = calendar.get( calendar.DAY_OF_MONTH );
      int month = calendar.get( calendar.MONTH ) + 1;
      int year = calendar.get( calendar.YEAR );

      out.println( "<select name=\""
        + name
        + "_month\" size=\""
        + size
        + "\" >" );

      String aString = null;
      String selectedMarker = null;

      for(int m=1; m<=12; m++)
      {
        if( m==month )
        {
          selectedMarker = " SELECTED";
        }
        else
        {
          selectedMarker = "";
        }

        out.println("<option value=\""
          + m
          + "\"" + selectedMarker + ">"
          + m
          + "</option>");
      }

      out.println("</select>");

      out.println("<select name=\""
        + name
        + "_day\" size=\""
        + size
        + "\" >" );

      for(int d=1; d<=31; d++)
      {
        if( d==day )
        {
          selectedMarker = " SELECTED";
        }
        else
        {
          selectedMarker = "";
        }

        out.println("<option value=\""
          + d
          + "\"" + selectedMarker + ">"
          + d
          + "</option>" );
      }

      out.println("</select>");

      out.println("<select name=\""
        + name
        + "_year\" size=\""
        + size
        + "\" >" );

      for( int y=year - 2; y <= year + 2; y++ )
      {
        if( y==year )
        {
          selectedMarker = " SELECTED";
        }
        else
        {
          selectedMarker = "";
        }

        out.println( "<option value=\""
        + y
        + "\"" + selectedMarker + ">"
        + y
        + "</option>" );
      }

      out.println( "</select>" );
      }
      catch (Exception ex)
      {
        throw new JspTagException("DateSelectTag: "
          + ex.getMessage() );
      }
      return SKIP_BODY;
    }

    public int doEndTag()
    {
      return EVAL_PAGE;
    }

    public String getName()
    {
      return (this.name);
    }

    public void setName(String parameter)
    {
      this.name = parameter;
    }

    public String getDefaultdate()
    {
      return (this.defaultdate);
    }

    public void setDefaultdate(String parameter)
    {
      this.defaultdate = parameter;
}
    
    public String getSize()
    {
      return (this.size);
    }

    public void setSize(String parameter)
    {
      this.size = parameter;
    }

}
