package com.wiley.tomcatbook;

import java.util.*;
import java.text.*;
import java.security.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class EncryptTag extends BodyTagSupport {

  protected String algorithm = "MD5";
  protected boolean addDelimiters = false;
  protected boolean returnOriginal = false;

  public int doAfterBody() throws JspTagException {

    try
    {
      BodyContent bodyContent = getBodyContent();
      String body = bodyContent.getString();

      bodyContent.clearBody();
      JspWriter writer = bodyContent.getEnclosingWriter();
      if (returnOriginal)
      {
        writer.println("<hr>");
        writer.println(body);
        writer.println("<hr>");
        writer.println("Algorithm: " + algorithm + " =&gt; ");
      }
      writer.print(encrypt(body, algorithm));
    }
    catch (Exception ex)
    {
      throw new JspTagException("EncryptTag: "
        + ex.getMessage() );
    }

    return SKIP_BODY;

  }
public String encrypt(String cleartext, String method)
  {
    if ("MD5".equalsIgnoreCase(method))
      return md5hash(cleartext);
    else if ("ROT13".equalsIgnoreCase(method))
      return rot13(cleartext);
    else if ("Reverse".equalsIgnoreCase(method))
      return reverse(cleartext);
    else
      return "<blink>Unsupported encryption method: " + method + "</blink>";
  }
public void setAlgorithm(String parameter)
  {
    this.algorithm = parameter;
  }

  public String getAlgorithm()
  {
    return (this.algorithm);
  }

  public void setReturnoriginal(boolean parameter)
  {
    this.returnOriginal = parameter;
  }

  public boolean getReturnoriginal()
  {
    return (this.returnOriginal);
  }
public static final String md5hash(String cleartext)
  {
    try
    {
      MessageDigest md = MessageDigest.getInstance("MD5");
      byte[] digest = md.digest(cleartext.getBytes());
      StringBuffer sb = new StringBuffer();
      for (int i = 0; i < digest.length; i++)
      {
        int hiNybble = digest[i] >> (byte) 0x04;
        int loNybble = digest[i] & (byte) 0x0F;
        sb.append(nybbleToUnsignedNybbleString(hiNybble));
        sb.append(nybbleToUnsignedNybbleString(loNybble));
        sb.append(":");
      }
      sb.deleteCharAt(sb.length() - 1);
      return sb.toString();
    }
    catch (NoSuchAlgorithmException nsae)
    {
      System.err.println("Couldn't get MD5 MessageDigest instance: " + nsae);
      nsae.printStackTrace(System.err);
      return null;
    }

    }

    public static final String nybbleToUnsignedNybbleString(int
      nybble)
    {
      int value = 0;
      if ((nybble & 0x01) != 0) value += 1;
      if ((nybble & 0x02) != 0) value += 2;
      if ((nybble & 0x04) != 0) value += 4;
      if ((nybble & 0x08) != 0) value += 8;
      return Integer.toString(value, 16);
    }
public static String rot13(String cleartext)
  {
    StringBuffer sb = new StringBuffer(cleartext);
    for (int i = 0; i < sb.length(); i++)
    {
      char ch = sb.charAt(i);
      if (ch >= 'a' && ch <= 'z')
      {
        ch += 13;
        if (ch > 'z') ch -= 26;
      }
      else if (ch >= 'A' && ch <= 'Z')
      {
        ch += 13;
        if (ch > 'Z') ch -= 26;
      }
      sb.setCharAt(i, ch);
    }
    return sb.toString();
  }
public static String reverse(String cleartext)
  {
    StringBuffer sb = new StringBuffer(cleartext);
    sb.reverse();
    return sb.toString();
  }
}
