<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jstl/xml" %>

<html>
<head>
  <title>JSTL: Support XML -- Transformation</title>
</head>
<body bgcolor="#FFFFFF">
<h3>Parse / Expr</h3>

<c:set var="xml">
  <a><b>header!</b></a>
</c:set>

<c:set var="xsl">
  <?xml version="1.0"?>
  <xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:template match="text()">
    <h1><xsl:value-of select="."/></h1>
  </xsl:template>

  </xsl:stylesheet>
</c:set>

Prints "header" as a header:<br />
<x:transform xml="${xml}" xslt="${xsl}"/>

<hr />

Prints "header" in normal size:<br />
<x:transform xml="${xml}" xslt="${xsl}" var="doc"/>
<x:out select="$doc//h1"/>

<hr size="5" />

<hr />
<h3>Transformations utilisant la sortie d'expressions XPath </h3>

<x:parse var="xml" xml="${xml}" />
<x:set var="miniDoc" select="$xml//b" />
<x:transform xslt="${xsl}" xml="${miniDoc}" />
<hr />

<h3>Transformations en ligne </h3>

<x:transform xslt="${xsl}">
  <a>
  <b>
    <c>Paragraph one!</c>
    <c>Paragraph foo!</c>
  </b>
  </a>
</x:transform>

</body>
</html>
