package action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import bean.Employee;
import form.EmployeeForm;

/**
 * @author Rick Hightower
 * @struts:action path="/editEmployee"
 *          attribute="employeeForm"
 *
 * @struts:action-forward name="form" path="/EmployeeForm.jsp"
 */
 public class EditEmployeeAction extends Action {

  /**
   * @see org.apache.struts.action.Action#execute(ActionMapping,
   */
   public ActionForward execute(
         ActionMapping mapping,
         ActionForm form,
         HttpServletRequest request,
         HttpServletResponse response)
                       throws Exception {

      int empid = Integer.parseInt(request.getParameter("id"));

            /* Remplir le formulaire de l'employ */
      if (form == null) {
            form = new EmployeeForm();
            if ("request".equals(mapping.getScope())) {
            request.setAttribute(mapping.getAttribute(),
form);
          } else {
            request.getSession()
              .setAttribute(mapping.getAttribute(), form);
          }
  }

            /* Charger les donnes de l'employ */
  EmployeeForm eform = (EmployeeForm) form;
  eform.getEmployee().load(empid);

            /* Dfinir les attributs du mode */
  eform.setAction(EmployeeForm.EDIT_MODE);

  return mapping.findForward("form");
  }
}
