package form;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import bean.Employee;

/**
* @author Rick Hightower
*
* @struts:form name="employeeForm"
*/
public class EmployeeForm extends ActionForm {

public static final String EDIT_MODE = "edit";
  public static final String DELETE_MODE = "delete";
  public static final String ADD_MODE = "add";

  String action;

  Employee employee;

  public EmployeeForm() {
    employee = new Employee();
    action = EmployeeForm.ADD_MODE;
  }

  public Employee getEmployee() {
    return employee;
  }
  public void setEmployee(Employee employee) {
    this.employee = employee;
  }

  /**
   * Renvoie l'action.
   * @return String
  */
  public String getAction() {
    return action;
  }

  /**
   * Dfinit l'action.
   * @param action L'action  paramtrer
   */
   public void setAction(String action) {
    this.action = action;
   }
  /**
  * @see org.apache.struts.action.ActionForm#reset(ActionMapping,
                                   HttpServletRequest)
   */
   public void reset(ActionMapping mapping,
                                   HttpServletRequest request) {

     this.employee = new Employee();
     this.action = ADD_MODE;
  }

  /**
   * @see org.apache.struts.action.ActionForm#validate(ActionMapping,
   *                               HttpServletRequest)
   **/
    public ActionErrors validate(ActionMapping arg0,
                                   HttpServletRequest arg1) {
       ActionErrors errors = new ActionErrors();
       if ((employee.getFirstName() == null)
           || (employee.getFirstName().length() < 3)) {

           errors.add("FirstName", new ActionError("error.employee.
           firstname"));
       }
        return errors;
  }
}
