package action;

import org.apache.struts.action.*;
import javax.servlet.http.*;
import form.EmployeeForm;
import bean.Dept;
import bean.Employee;

/**
 * @author Rick Hightower
 * @struts:action name="employeeForm"
 * path="/updateEmployee"
 * input="/EmployeeForm.jsp"
 * attribute="employeeForm"
 *
 * @struts:action-forward name="listing" path="/EmployeeListing.jsp"
 */
public class UpdateEmployeeAction extends Action {

  public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
                   throws Exception {

        /* Transtyper ActionForm en EmployeeForm */
      EmployeeForm eform = (EmployeeForm) form;

        /* Ajouter, modifier ou supprimer cet employ */

        /* AJOUTER */
      if (EmployeeForm.ADD_MODE.equals(eform.getAction())) {

        Employee employee = eform.getEmployee();
        int deptid = Integer.parseInt(
                     request.getParameter("deptid"));

        employee.setDeptId(deptid);
         eform.getEmployee().add();
        /* MODIFIER */
      } else if (EmployeeForm.EDIT_MODE.equals(eform.getAction())) {
         eform.getEmployee().edit();

        /* SUPPRIMER */
      } else if (EmployeeForm.DELETE_MODE.equals(eform.getAction())){
         eform.getEmployee().remove();

        /* ETAT ILLEGAL */
      } else {
         throw new java.lang.IllegalStateException("invalid " +
                   "action");
      }

      Dept dept = new Dept();
      int deptid = eform.getEmployee().getDeptId();
      dept.setId(deptid);
      request.setAttribute("dept",dept);

      return mapping.findForward("listing");
    }
}
