package com.wiley.tomcatbook;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import javax.naming.*;
import javax.sql.*;

public class ClientListPooledServlet extends HttpServlet
{

  private DataSource ds;

  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);
    try
    {
      Context initCtx = new InitialContext();
      Context envCtx = (Context) initCtx.lookup("java:comp/env");
      ds = (DataSource) envCtx.lookup("jdbc/tomcatbook");
    }
    catch (Exception e)
    {
      throw new UnavailableException(e.getMessage());
    }
  }

  public void doGet (HttpServletRequest request,
HttpServletResponse response)
      throws ServletException, IOException
  {
    response.setContentType("text/html");
    PrintWriter out = response.getWriter();

    out.println("<html>");
    out.println("<head>");
    out.println("<title>Liste des clients</title>");
    out.println("</head>");
    out.println("<body>");

    out.println("<h1>Contacts</h1>");
    out.println("<table border=\"1\">");
    out.println("<tr>");
    out.println("<th>Prnom</th>");
    out.println("<th>Nom</th>");
    out.println("<th>Tlphone</th>");
    out.println("</tr>");
    try
    {
      Connection con = ds.getConnection();
      Statement s = con.createStatement();
      ResultSet rs = s.executeQuery("SELECT * FROM CLIENT");

      while(rs.next())
      {
        out.println("<tr>");
        out.println("<td>" + rs.getString("first_name") +
"</td>");
        out.println("<td>" + rs.getString("last_name") +
"</td>");
        out.println("<td>" + rs.getString("phone") + "</td>");
        out.println("</tr>");
      }

      rs.close();
      s.close();
      con.close();

      }
      catch (SQLException sqle) {
        response.sendError(500, "Exception lors de la communication avec la base de donnes: " + sqle);
      }
    out.println("</table>");
    out.println("</body>");
    out.println("</html>");
  }

}
