package com.neo.smartobjects;

public class SmartObjectException extends Exception {

  private Throwable nestedException;

  SmartObjectException() {
    super();
  }

  SmartObjectException(Throwable nestedException) {
    this();
    this.nestedException = nestedException;
  }

  SmartObjectException(String message) {
    super(message);
  }

  SmartObjectException(String message, Throwable nestedException) {
    this(message + " Nested exception: " + nestedException);
    this.nestedException = nestedException;
  }

  public Throwable getNestedException() {
    return nestedException;
  }
}
